/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.modules.sarif;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IResourceLocation;
import gov.nist.secauto.metaschema.core.model.constraint.ConstraintValidationFinding;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.model.validation.IValidationFinding;
import gov.nist.secauto.metaschema.core.model.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.core.model.validation.XmlSchemaContentValidator;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.IVersionInfo;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.SerializationFeature;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.schemastore.json.sarif.x210.Artifact;
import org.schemastore.json.sarif.x210.ArtifactLocation;
import org.schemastore.json.sarif.x210.Location;
import org.schemastore.json.sarif.x210.LogicalLocation;
import org.schemastore.json.sarif.x210.Message;
import org.schemastore.json.sarif.x210.MultiformatMessageString;
import org.schemastore.json.sarif.x210.PhysicalLocation;
import org.schemastore.json.sarif.x210.Region;
import org.schemastore.json.sarif.x210.ReportingDescriptor;
import org.schemastore.json.sarif.x210.Result;
import org.schemastore.json.sarif.x210.Run;
import org.schemastore.json.sarif.x210.Sarif;
import org.schemastore.json.sarif.x210.Tool;
import org.schemastore.json.sarif.x210.ToolComponent;

public final class SarifValidationHandler {
    @NonNull
    private final URI source;
    @Nullable
    private final IVersionInfo toolVersion;
    private final AtomicInteger artifactIndex = new AtomicInteger(-1);
    private final AtomicInteger ruleIndex = new AtomicInteger(-1);
    @NonNull
    private final Map<URI, ArtifactRecord> artifacts = new LinkedHashMap<URI, ArtifactRecord>();
    @NonNull
    private final List<AbstractRuleRecord> rules = new LinkedList<AbstractRuleRecord>();
    @NonNull
    private final Map<IConstraint, ConstraintRuleRecord> constraintRules = new LinkedHashMap<IConstraint, ConstraintRuleRecord>();
    @NonNull
    private final List<IResult> results = new LinkedList<IResult>();
    @NonNull
    private final SchemaRuleRecord schemaRule = new SchemaRuleRecord();
    private boolean schemaValid = true;

    public SarifValidationHandler(@NonNull URI source, @Nullable IVersionInfo toolVersion) {
        if (!source.isAbsolute()) {
            throw new IllegalArgumentException(String.format("The source URI '%s' is not absolute.", source.toASCIIString()));
        }
        this.source = source;
        this.toolVersion = toolVersion;
    }

    public URI getSource() {
        return this.source;
    }

    public IVersionInfo getToolVersion() {
        return this.toolVersion;
    }

    public void addFindings(@NonNull List<? extends IValidationFinding> findings) {
        for (IValidationFinding iValidationFinding : findings) {
            assert (iValidationFinding != null);
            this.addFinding(iValidationFinding);
        }
    }

    public void addFinding(@NonNull IValidationFinding finding) {
        if (finding instanceof JsonSchemaContentValidator.JsonValidationFinding) {
            this.addJsonValidationFinding((JsonSchemaContentValidator.JsonValidationFinding)finding);
        } else if (finding instanceof XmlSchemaContentValidator.XmlValidationFinding) {
            this.addXmlValidationFinding((XmlSchemaContentValidator.XmlValidationFinding)finding);
        } else if (finding instanceof ConstraintValidationFinding) {
            this.addConstraintValidationFinding((ConstraintValidationFinding)finding);
        } else {
            throw new IllegalStateException();
        }
    }

    public URI relativize(@NonNull URI output, @NonNull URI artifact) throws IOException {
        try {
            return UriUtils.relativize((URI)output, (URI)artifact, (boolean)true);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    private ConstraintRuleRecord getRuleRecord(@NonNull IConstraint constraint) {
        ConstraintRuleRecord retval = this.constraintRules.get(constraint);
        if (retval == null) {
            retval = new ConstraintRuleRecord(constraint);
            this.constraintRules.put(constraint, retval);
            this.rules.add(retval);
        }
        return retval;
    }

    private ArtifactRecord getArtifactRecord(@NonNull URI artifactUri) {
        ArtifactRecord retval = this.artifacts.get(artifactUri);
        if (retval == null) {
            retval = new ArtifactRecord(artifactUri);
            this.artifacts.put(artifactUri, retval);
        }
        return retval;
    }

    private void addJsonValidationFinding(@NonNull JsonSchemaContentValidator.JsonValidationFinding finding) {
        this.results.add(new SchemaResult((IValidationFinding)finding));
        if (this.schemaValid && IValidationFinding.Kind.FAIL.equals((Object)finding.getKind())) {
            this.schemaValid = false;
        }
    }

    private void addXmlValidationFinding(@NonNull XmlSchemaContentValidator.XmlValidationFinding finding) {
        this.results.add(new SchemaResult((IValidationFinding)finding));
        if (this.schemaValid && IValidationFinding.Kind.FAIL.equals((Object)finding.getKind())) {
            this.schemaValid = false;
        }
    }

    private void addConstraintValidationFinding(@NonNull ConstraintValidationFinding finding) {
        this.results.add(new ConstraintResult(finding));
    }

    public void write(@NonNull Path outputFile) throws IOException {
        URI output = (URI)ObjectUtils.notNull((Object)outputFile.toUri());
        Sarif sarif = new Sarif();
        sarif.setVersion("2.1.0");
        Run run = new Run();
        sarif.addRun(run);
        Artifact artifact = new Artifact();
        artifact.setLocation(this.getArtifactRecord(this.source).generateArtifactLocation(output));
        run.addArtifact(artifact);
        for (IResult result : this.results) {
            result.generateResults(output).forEach(run::addResult);
        }
        if (!this.rules.isEmpty() || this.toolVersion != null) {
            Tool tool = new Tool();
            ToolComponent driver = new ToolComponent();
            IVersionInfo toolVersion = this.getToolVersion();
            if (toolVersion != null) {
                driver.setName(toolVersion.getName());
                driver.setVersion(toolVersion.getVersion());
            }
            for (AbstractRuleRecord rule : this.rules) {
                driver.addRule(rule.generate());
            }
            tool.setDriver(driver);
            run.setTool(tool);
        }
        IBindingContext.instance().newSerializer(Format.JSON, Sarif.class).disableFeature(SerializationFeature.SERIALIZE_ROOT).serialize((IBoundObject)sarif, outputFile, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
    }

    private final class SchemaRuleRecord
    extends AbstractRuleRecord {
        private SchemaRuleRecord() {
        }

        @Override
        protected ReportingDescriptor generate() {
            ReportingDescriptor retval = new ReportingDescriptor();
            retval.setId(this.getId());
            retval.setGuid(this.getGuid());
            return retval;
        }

        public String getId() {
            return "schema-valid";
        }
    }

    private final class ConstraintRuleRecord
    extends AbstractRuleRecord {
        @NonNull
        private final IConstraint constraint;

        public ConstraintRuleRecord(IConstraint constraint) {
            this.constraint = constraint;
        }

        @NonNull
        public IConstraint getConstraint() {
            return this.constraint;
        }

        @Override
        protected ReportingDescriptor generate() {
            MarkupLine description;
            ReportingDescriptor retval = new ReportingDescriptor();
            IConstraint constraint = this.getConstraint();
            String id = constraint.getId();
            if (id != null) {
                retval.setId(id);
            }
            retval.setGuid(this.getGuid());
            String formalName = constraint.getFormalName();
            if (formalName != null) {
                MultiformatMessageString text = new MultiformatMessageString();
                text.setText(formalName);
                retval.setShortDescription(text);
            }
            if ((description = constraint.getDescription()) != null) {
                MultiformatMessageString text = new MultiformatMessageString();
                text.setMarkdown(description.toMarkdown());
                retval.setFullDescription(text);
            }
            return retval;
        }
    }

    private final class ArtifactRecord {
        @NonNull
        private final URI uri;
        private final int index;

        public ArtifactRecord(URI uri) {
            this.uri = uri;
            this.index = SarifValidationHandler.this.artifactIndex.addAndGet(1);
        }

        @NonNull
        public URI getUri() {
            return this.uri;
        }

        public int getIndex() {
            return this.index;
        }

        public ArtifactLocation generateArtifactLocation(@NonNull URI baseUri) throws IOException {
            ArtifactLocation location = new ArtifactLocation();
            location.setUri(SarifValidationHandler.this.relativize(baseUri, this.getUri()));
            location.setIndex(BigInteger.valueOf(this.getIndex()));
            return location;
        }
    }

    private final class SchemaResult
    extends AbstractResult<IValidationFinding> {
        protected SchemaResult(IValidationFinding finding) {
            super(SarifValidationHandler.this, finding);
        }

        @Override
        public List<Result> generateResults(@NonNull URI output) throws IOException {
            Object finding = this.getFinding();
            Result result = new Result();
            result.setRuleId(SarifValidationHandler.this.schemaRule.getId());
            result.setRuleIndex(BigInteger.valueOf(SarifValidationHandler.this.schemaRule.getIndex()));
            result.setGuid(SarifValidationHandler.this.schemaRule.getGuid());
            result.setKind(this.kind((IValidationFinding)finding).getLabel());
            result.setLevel(this.level(finding.getSeverity()).getLabel());
            this.message((IValidationFinding)finding, result);
            this.location((IValidationFinding)finding, result, output);
            return CollectionUtil.singletonList((Object)result);
        }
    }

    private final class ConstraintResult
    extends AbstractResult<ConstraintValidationFinding> {
        protected ConstraintResult(ConstraintValidationFinding finding) {
            super(SarifValidationHandler.this, (IValidationFinding)finding);
        }

        @Override
        public List<Result> generateResults(@NonNull URI output) throws IOException {
            ConstraintValidationFinding finding = (ConstraintValidationFinding)this.getFinding();
            LinkedList<Result> retval = new LinkedList<Result>();
            Kind kind = this.kind((IValidationFinding)finding);
            SeverityLevel level = this.level(finding.getSeverity());
            for (IConstraint constraint : finding.getConstraints()) {
                assert (constraint != null);
                ConstraintRuleRecord rule = SarifValidationHandler.this.getRuleRecord(constraint);
                Result result = new Result();
                String id = constraint.getId();
                if (id != null) {
                    result.setRuleId(id);
                }
                result.setRuleIndex(BigInteger.valueOf(rule.getIndex()));
                result.setGuid(rule.getGuid());
                result.setKind(kind.getLabel());
                result.setLevel(level.getLabel());
                this.message((IValidationFinding)finding, result);
                this.location((IValidationFinding)finding, result, output);
                retval.add(result);
            }
            return retval;
        }
    }

    private static interface IResult {
        @NonNull
        public IValidationFinding getFinding();

        @NonNull
        public List<Result> generateResults(@NonNull URI var1) throws IOException;
    }

    private abstract class AbstractRuleRecord {
        private final int index;
        @NonNull
        private final UUID guid;

        private AbstractRuleRecord() {
            this.index = SarifValidationHandler.this.ruleIndex.addAndGet(1);
            this.guid = (UUID)ObjectUtils.notNull((Object)UUID.randomUUID());
        }

        public int getIndex() {
            return this.index;
        }

        @NonNull
        public UUID getGuid() {
            return this.guid;
        }

        @NonNull
        protected abstract ReportingDescriptor generate();
    }

    private static abstract class AbstractResult<T extends IValidationFinding>
    implements IResult {
        @NonNull
        private final T finding;
        final /* synthetic */ SarifValidationHandler this$0;

        protected AbstractResult(T finding) {
            this.this$0 = var1_1;
            this.finding = finding;
        }

        public T getFinding() {
            return this.finding;
        }

        @NonNull
        protected Kind kind(@NonNull IValidationFinding finding) {
            Kind retval;
            IValidationFinding.Kind kind = finding.getKind();
            switch (kind) {
                case FAIL: {
                    retval = Kind.FAIL;
                    break;
                }
                case INFORMATIONAL: {
                    retval = Kind.INFORMATIONAL;
                    break;
                }
                case NOT_APPLICABLE: {
                    retval = Kind.NOT_APPLICABLE;
                    break;
                }
                case PASS: {
                    retval = Kind.PASS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid finding kind '%s'.", kind));
                }
            }
            return retval;
        }

        @NonNull
        protected SeverityLevel level(@NonNull IConstraint.Level severity) {
            SeverityLevel retval;
            switch (severity) {
                case CRITICAL: 
                case ERROR: {
                    retval = SeverityLevel.ERROR;
                    break;
                }
                case INFORMATIONAL: 
                case DEBUG: {
                    retval = SeverityLevel.NOTE;
                    break;
                }
                case WARNING: {
                    retval = SeverityLevel.WARNING;
                    break;
                }
                case NONE: {
                    retval = SeverityLevel.NONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid severity '%s'.", severity));
                }
            }
            return retval;
        }

        protected void message(@NonNull IValidationFinding finding, @NonNull Result result) {
            String message = finding.getMessage();
            if (message == null) {
                message = "";
            }
            Message msg = new Message();
            msg.setText(message);
            result.setMessage(msg);
        }

        protected void location(@NonNull IValidationFinding finding, @NonNull Result result, @NonNull URI base) throws IOException {
            IResourceLocation location = finding.getLocation();
            if (location != null) {
                Region region = new Region();
                if (location.getLine() > -1) {
                    region.setStartLine(BigInteger.valueOf(location.getLine()));
                    region.setEndLine(BigInteger.valueOf(location.getLine()));
                }
                if (location.getColumn() > -1) {
                    region.setStartColumn(BigInteger.valueOf(location.getColumn()));
                    region.setEndColumn(BigInteger.valueOf(location.getColumn() + 1));
                }
                if (location.getByteOffset() > -1L) {
                    region.setByteOffset(BigInteger.valueOf(location.getByteOffset()));
                    region.setByteLength(BigInteger.ZERO);
                }
                if (location.getCharOffset() > -1L) {
                    region.setCharOffset(BigInteger.valueOf(location.getCharOffset()));
                    region.setCharLength(BigInteger.ZERO);
                }
                PhysicalLocation physical = new PhysicalLocation();
                URI documentUri = finding.getDocumentUri();
                if (documentUri != null) {
                    physical.setArtifactLocation(this.this$0.getArtifactRecord(documentUri).generateArtifactLocation(base));
                }
                physical.setRegion(region);
                LogicalLocation logical = new LogicalLocation();
                logical.setDecoratedName(finding.getPath());
                Location loc = new Location();
                loc.setPhysicalLocation(physical);
                loc.setLogicalLocation(logical);
                result.addLocation(loc);
            }
        }
    }

    private static enum SeverityLevel {
        NONE("none"),
        NOTE("note"),
        WARNING("warning"),
        ERROR("error");

        @NonNull
        private final String label;

        private SeverityLevel(String label) {
            this.label = label;
        }

        @NonNull
        public String getLabel() {
            return this.label;
        }
    }

    private static enum Kind {
        NOT_APPLICABLE("notApplicable"),
        PASS("pass"),
        FAIL("fail"),
        REVIEW("review"),
        OPEN("open"),
        INFORMATIONAL("informational");

        @NonNull
        private final String label;

        private Kind(String label) {
            this.label = label;
        }

        @NonNull
        public String getLabel() {
            return this.label;
        }
    }
}

