/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.datatype.adapter.IntegerAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.math.BigInteger;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Logical Location", description="A logical location of a construct that produced a result.", name="logicalLocation", moduleClass=SarifModule.class)
public class LogicalLocation
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="Logical Location Name", description="Identifies the construct in which the result occurred. For example, this property might contain the name of a class or a method.", useName="name")
    private String _name;
    @BoundField(formalName="Index", description="The index within the logical locations array.", useName="index", defaultValue="-1", typeAdapter=IntegerAdapter.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="@id >= -1", message="The index '{ . }' is not greater than or equal to '-1'.")}))
    private BigInteger _index;
    @BoundField(formalName="Fully Qualified Name", description="The human-readable fully qualified name of the logical location.", useName="fullyQualifiedName")
    private String _fullyQualifiedName;
    @BoundField(formalName="Decorated Name", description="The machine-readable name for the logical location, such as a mangled function name provided by a C++ compiler that encodes calling convention, return type and other details along with the function name.", useName="decoratedName")
    private String _decoratedName;
    @BoundField(formalName="Parent Index", description="Identifies the index of the immediate parent of the construct in which the result was detected. For example, this property might point to a logical location that represents the namespace that holds a type.", useName="parentIndex", defaultValue="-1", typeAdapter=IntegerAdapter.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="@id >= -1", message="The index '{ . }' is not greater than or equal to '-1'.")}))
    private BigInteger _parentIndex;
    @BoundField(formalName="Kind", description="The type of construct this logical location component refers to. Should be one of 'function', 'member', 'module', 'namespace', 'parameter', 'resource', 'returnType', 'type', 'variable', 'object', 'array', 'property', 'value', 'element', 'text', 'attribute', 'comment', 'declaration', 'dtd' or 'processingInstruction', if any of those accurately describe the construct.", useName="kind")
    private String _kind;

    public LogicalLocation() {
        this(null);
    }

    public LogicalLocation(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    public BigInteger getIndex() {
        return this._index;
    }

    public void setIndex(BigInteger value) {
        this._index = value;
    }

    public String getFullyQualifiedName() {
        return this._fullyQualifiedName;
    }

    public void setFullyQualifiedName(String value) {
        this._fullyQualifiedName = value;
    }

    public String getDecoratedName() {
        return this._decoratedName;
    }

    public void setDecoratedName(String value) {
        this._decoratedName = value;
    }

    public BigInteger getParentIndex() {
        return this._parentIndex;
    }

    public void setParentIndex(BigInteger value) {
        this._parentIndex = value;
    }

    public String getKind() {
        return this._kind;
    }

    public void setKind(String value) {
        this._kind = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

