/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Message", description="Encapsulates a message intended to be read by the end user.", name="message", moduleClass=SarifModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="exists(@id|text)", message="At least one id or text must be provided.")}))
public class Message
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Message Identifier", description="The id of the message.", name="id", required=true, typeAdapter=StringAdapter.class)
    private String _id;
    @BoundField(formalName="Text", description="A plain text message string.", useName="text")
    private String _text;
    @BoundField(formalName="Markdown", description="A Markdown message string.", useName="markdown")
    private String _markdown;
    @BoundField(formalName="Argument", description="A sequence of strings to substitute into the message string.", useName="argument", maxOccurs=-1, groupAs=@GroupAs(name="arguments", inJson=JsonGroupAsBehavior.LIST))
    private List<String> _arguments;

    public Message() {
        this(null);
    }

    public Message(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String value) {
        this._text = value;
    }

    public String getMarkdown() {
        return this._markdown;
    }

    public void setMarkdown(String value) {
        this._markdown = value;
    }

    public List<String> getArguments() {
        return this._arguments;
    }

    public void setArguments(List<String> value) {
        this._arguments = value;
    }

    public boolean addArgument(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._arguments == null) {
            this._arguments = new LinkedList<String>();
        }
        return this._arguments.add(value);
    }

    public boolean removeArgument(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._arguments != null && this._arguments.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

