/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.ArtifactLocation;
import org.schemastore.json.sarif.x210.Region;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Physical Location", description="A physical location relevant to a result. Specifies a reference to a programming artifact together with a range of bytes or characters within that artifact.", name="physicalLocation", moduleClass=SarifModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="exists(address|artifactLocation)", message="At least one address or artifactLocation must be provided.")}))
public class PhysicalLocation
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Address", description="A physical or virtual address, or a range of addresses, in an 'addressable region' (memory or a binary file).", useName="address")
    private Address _address;
    @BoundAssembly(formalName="Artifact Location", description="The location of the artifact.", useName="artifactLocation")
    private ArtifactLocation _artifactLocation;
    @BoundAssembly(formalName="Region", description="Specifies a portion of the artifact.", useName="region")
    private Region _region;
    @BoundAssembly(formalName="Context Region", description="Specifies a portion of the artifact that encloses the region. Allows a viewer to display additional context around the region.", useName="contextRegion")
    private Region _contextRegion;

    public PhysicalLocation() {
        this(null);
    }

    public PhysicalLocation(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public Address getAddress() {
        return this._address;
    }

    public void setAddress(Address value) {
        this._address = value;
    }

    public ArtifactLocation getArtifactLocation() {
        return this._artifactLocation;
    }

    public void setArtifactLocation(ArtifactLocation value) {
        this._artifactLocation = value;
    }

    public Region getRegion() {
        return this._region;
    }

    public void setRegion(Region value) {
        this._region = value;
    }

    public Region getContextRegion() {
        return this._contextRegion;
    }

    public void setContextRegion(Region value) {
        this._contextRegion = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Address", description="A physical or virtual address, or a range of addresses, in an 'addressable region' (memory or a binary file).", name="address", moduleClass=SarifModule.class)
    public static class Address
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;

        public Address() {
            this(null);
        }

        public Address(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

