/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.datatype.adapter.IntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.math.BigInteger;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Reporting Descriptor Reference", description="Information about how to locate a relevant reporting descriptor.", name="reportingDescriptorReference", moduleClass=SarifModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="@id|@guid|index", message="At least one id, guid, or index must be provided.")}))
public class ReportingDescriptorReference
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Reporting Descriptor Identifier", description="The id of the descriptor.", name="id", required=true, typeAdapter=StringAdapter.class)
    private String _id;
    @BoundFlag(formalName="Reporting Descriptor Unique Identifier", description="A stable, unique identifier for the reporting descriptor.", name="guid", typeAdapter=UuidAdapter.class)
    private UUID _guid;
    @BoundField(formalName="Index", description="The index into an array of descriptors in toolComponent.ruleDescriptors, toolComponent.notificationDescriptors, or toolComponent.taxonomyDescriptors, depending on context.", useName="index", defaultValue="-1", typeAdapter=IntegerAdapter.class)
    private BigInteger _index;

    public ReportingDescriptorReference() {
        this(null);
    }

    public ReportingDescriptorReference(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public UUID getGuid() {
        return this._guid;
    }

    public void setGuid(UUID value) {
        this._guid = value;
    }

    public BigInteger getIndex() {
        return this._index;
    }

    public void setIndex(BigInteger value) {
        this._index = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

