/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.Artifact;
import org.schemastore.json.sarif.x210.Result;
import org.schemastore.json.sarif.x210.SarifModule;
import org.schemastore.json.sarif.x210.Tool;

@MetaschemaAssembly(formalName="Run", description="Describes a single run of an analysis tool, and contains the reported output of that run.", name="run", moduleClass=SarifModule.class)
public class Run
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Tool", description="Information about the tool or tool pipeline that generated the results in this run. A run can only contain results produced by a single tool or tool pipeline. A run can aggregate results from multiple log files, as long as context around the tool run (tool command-line arguments and the like) is identical for all aggregated files.", useName="tool")
    private Tool _tool;
    @BoundAssembly(formalName="Artifact", description="A sequence of artifacts relevant to the run.", useName="artifact", maxOccurs=-1, groupAs=@GroupAs(name="artifacts", inJson=JsonGroupAsBehavior.LIST))
    private List<Artifact> _artifacts;
    @BoundAssembly(formalName="Result", description="The set of results contained in an SARIF log. The results array can be omitted when a run is solely exporting rules metadata. It must be present (but may be empty) if a log file represents an actual scan.", useName="result", maxOccurs=-1, groupAs=@GroupAs(name="results", inJson=JsonGroupAsBehavior.LIST))
    private List<Result> _results;

    public Run() {
        this(null);
    }

    public Run(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public Tool getTool() {
        return this._tool;
    }

    public void setTool(Tool value) {
        this._tool = value;
    }

    public List<Artifact> getArtifacts() {
        return this._artifacts;
    }

    public void setArtifacts(List<Artifact> value) {
        this._artifacts = value;
    }

    public boolean addArtifact(Artifact item) {
        Artifact value = (Artifact)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._artifacts == null) {
            this._artifacts = new LinkedList<Artifact>();
        }
        return this._artifacts.add(value);
    }

    public boolean removeArtifact(Artifact item) {
        Artifact value = (Artifact)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._artifacts != null && this._artifacts.remove(value);
    }

    public List<Result> getResults() {
        return this._results;
    }

    public void setResults(List<Result> value) {
        this._results = value;
    }

    public boolean addResult(Result item) {
        Result value = (Result)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._results == null) {
            this._results = new LinkedList<Result>();
        }
        return this._results.add(value);
    }

    public boolean removeResult(Result item) {
        Result value = (Result)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._results != null && this._results.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

