/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.Run;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Static Analysis Results Interchange Format", description="A standard format for the output of static analysis tools.", name="sarif", moduleClass=SarifModule.class, rootName="sarif", remarks="Note, Metaschema does not support an anonymous top-level assembly without a key name in JSON and YAML, which is required for SARIF.")
public class Sarif
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="SARIF Model Version", description="The version of the SARIF Model used for conforming instances.", useName="version", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="2.1.0", description="")})}))
    private String _version;
    @BoundAssembly(formalName="Run", description="Describes a single run of an analysis tool, and contains the reported output of that run.", useName="run", maxOccurs=-1, groupAs=@GroupAs(name="runs", inJson=JsonGroupAsBehavior.LIST))
    private List<Run> _runs;

    public Sarif() {
        this(null);
    }

    public Sarif(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String value) {
        this._version = value;
    }

    public List<Run> getRuns() {
        return this._runs;
    }

    public void setRuns(List<Run> value) {
        this._runs = value;
    }

    public boolean addRun(Run item) {
        Run value = (Run)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._runs == null) {
            this._runs = new LinkedList<Run>();
        }
        return this._runs.add(value);
    }

    public boolean removeRun(Run item) {
        Run value = (Run)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._runs != null && this._runs.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

