/*
 * Decompiled with CFR 0.152.
 */
package com.example.metaschema;

import com.example.metaschema.KeyConstraintField;
import com.example.metaschema.MetaschemaModelModule;
import com.example.metaschema.Property;
import com.example.metaschema.Remarks;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Index Has Key Constraint", name="flag-index-has-key", moduleClass=MetaschemaModelModule.class)
public class FlagIndexHasKey
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Constraint Identifier", name="id", typeAdapter=TokenAdapter.class)
    private String _id;
    @BoundFlag(formalName="Constraint Severity Level", name="level", defaultValue="ERROR", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="CRITICAL", description="A violation of the constraint represents a serious fault in the content that will prevent typical use of the content."), @AllowedValue(value="ERROR", description="A violation of the constraint represents a fault in the content. This may include issues around compatibility, integrity, consistency, etc."), @AllowedValue(value="WARNING", description="A violation of the constraint represents a potential issue with the content."), @AllowedValue(value="INFORMATIONAL", description="A violation of the constraint represents a point of interest."), @AllowedValue(value="DEBUG", description="A violation of the constraint represents a fault in the content that may warrant review by a developer when performing model or tool development.")})}))
    private String _level;
    @BoundFlag(formalName="Index Name", name="name", required=true, typeAdapter=TokenAdapter.class)
    private String _name;
    @BoundField(formalName="Formal Name", description="A formal name for the data construct, to be presented in documentation.", useName="formal-name")
    private String _formalName;
    @BoundField(formalName="Description", description="A short description of the data construct's purpose, describing the constructs semantics.", useName="description", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _description;
    @BoundAssembly(formalName="Property", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Key Constraint Field", useName="key-field", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="key-fields", inJson=JsonGroupAsBehavior.LIST))
    private List<KeyConstraintField> _keyFields;
    @BoundField(formalName="Constraint Condition Violation Message", useName="message")
    private String _message;
    @BoundField(formalName="Remarks", description="Any explanatory or helpful information to be provided about the remarks parent.", useName="remarks")
    private Remarks _remarks;

    public FlagIndexHasKey() {
        this(null);
    }

    public FlagIndexHasKey(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public String getLevel() {
        return this._level;
    }

    public void setLevel(String value) {
        this._level = value;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    public String getFormalName() {
        return this._formalName;
    }

    public void setFormalName(String value) {
        this._formalName = value;
    }

    public MarkupLine getDescription() {
        return this._description;
    }

    public void setDescription(MarkupLine value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<KeyConstraintField> getKeyFields() {
        return this._keyFields;
    }

    public void setKeyFields(List<KeyConstraintField> value) {
        this._keyFields = value;
    }

    public boolean addKeyField(KeyConstraintField item) {
        KeyConstraintField value = (KeyConstraintField)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._keyFields == null) {
            this._keyFields = new LinkedList<KeyConstraintField>();
        }
        return this._keyFields.add(value);
    }

    public boolean removeKeyField(KeyConstraintField item) {
        KeyConstraintField value = (KeyConstraintField)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._keyFields != null && this._keyFields.remove(value);
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String value) {
        this._message = value;
    }

    public Remarks getRemarks() {
        return this._remarks;
    }

    public void setRemarks(Remarks value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

