/*
 * Decompiled with CFR 0.152.
 */
package com.example.metaschema;

import com.example.metaschema.MetaschemaModelModule;
import com.example.metaschema.Property;
import com.example.metaschema.Remarks;
import com.example.metaschema.UseName;
import gov.nist.secauto.metaschema.core.datatype.adapter.PositiveIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Flag Reference", name="flag-reference", moduleClass=MetaschemaModelModule.class)
public class FlagReference
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Global Flag Reference", name="ref", required=true, typeAdapter=TokenAdapter.class)
    private String _ref;
    @BoundFlag(formalName="Flag Reference Binary Name", name="index", typeAdapter=PositiveIntegerAdapter.class)
    private BigInteger _index;
    @BoundFlag(formalName="Deprecated Version", name="deprecated", typeAdapter=StringAdapter.class)
    private String _deprecated;
    @BoundFlag(formalName="Default Flag Value", name="default", typeAdapter=StringAdapter.class)
    private String _default;
    @BoundFlag(formalName="Is Flag Required?", name="required", defaultValue="no", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="yes", description="The flag is required."), @AllowedValue(value="no", description="The flag is optional.")})}))
    private String _required;
    @BoundField(formalName="Formal Name", description="A formal name for the data construct, to be presented in documentation.", useName="formal-name")
    private String _formalName;
    @BoundField(formalName="Description", description="A short description of the data construct's purpose, describing the constructs semantics.", useName="description", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _description;
    @BoundAssembly(formalName="Property", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundField(formalName="Use Name", description="Allows the name of the definition to be overridden.", useName="use-name")
    private UseName _useName;
    @BoundField(formalName="Remarks", description="Any explanatory or helpful information to be provided about the remarks parent.", useName="remarks")
    private Remarks _remarks;

    public FlagReference() {
        this(null);
    }

    public FlagReference(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getRef() {
        return this._ref;
    }

    public void setRef(String value) {
        this._ref = value;
    }

    public BigInteger getIndex() {
        return this._index;
    }

    public void setIndex(BigInteger value) {
        this._index = value;
    }

    public String getDeprecated() {
        return this._deprecated;
    }

    public void setDeprecated(String value) {
        this._deprecated = value;
    }

    public String getDefault() {
        return this._default;
    }

    public void setDefault(String value) {
        this._default = value;
    }

    public String getRequired() {
        return this._required;
    }

    public void setRequired(String value) {
        this._required = value;
    }

    public String getFormalName() {
        return this._formalName;
    }

    public void setFormalName(String value) {
        this._formalName = value;
    }

    public MarkupLine getDescription() {
        return this._description;
    }

    public void setDescription(MarkupLine value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public UseName getUseName() {
        return this._useName;
    }

    public void setUseName(UseName value) {
        this._useName = value;
    }

    public Remarks getRemarks() {
        return this._remarks;
    }

    public void setRemarks(Remarks value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

