/*
 * Decompiled with CFR 0.152.
 */
package com.example.metaschema;

import com.example.metaschema.Example;
import com.example.metaschema.FlagConstraints;
import com.example.metaschema.MetaschemaModelModule;
import com.example.metaschema.Property;
import com.example.metaschema.Remarks;
import gov.nist.secauto.metaschema.core.datatype.adapter.PositiveIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Inline Flag Definition", name="inline-define-flag", moduleClass=MetaschemaModelModule.class)
public class InlineDefineFlag
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Inline Flag Name", name="name", required=true, typeAdapter=TokenAdapter.class)
    private String _name;
    @BoundFlag(formalName="Inline Flag Binary Name", name="index", typeAdapter=PositiveIntegerAdapter.class)
    private BigInteger _index;
    @BoundFlag(formalName="Deprecated Version", name="deprecated", typeAdapter=StringAdapter.class)
    private String _deprecated;
    @BoundFlag(formalName="Flag Value Data Type", name="as-type", defaultValue="string", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="base64", description="The [base64](https://pages.nist.gov/metaschema/specification/datatypes/#base64) data type."), @AllowedValue(value="boolean", description="The [boolean](https://pages.nist.gov/metaschema/specification/datatypes/#boolean) data type."), @AllowedValue(value="date", description="The [date](https://pages.nist.gov/metaschema/specification/datatypes/#date) data type."), @AllowedValue(value="date-time", description="The [date-time](https://pages.nist.gov/metaschema/specification/datatypes/#date-time) data type."), @AllowedValue(value="date-time-with-timezone", description="The [date-time-with-timezone](https://pages.nist.gov/metaschema/specification/datatypes/#date-time-with-timezone) data type."), @AllowedValue(value="date-with-timezone", description="The [date-with-timezone](https://pages.nist.gov/metaschema/specification/datatypes/#date-with-timezone) data type."), @AllowedValue(value="day-time-duration", description="The [day-time-duration](https://pages.nist.gov/metaschema/specification/datatypes/#day-time-duration) data type."), @AllowedValue(value="decimal", description="The [decimal](https://pages.nist.gov/metaschema/specification/datatypes/#decimal) data type."), @AllowedValue(value="email-address", description="The [email-address](https://pages.nist.gov/metaschema/specification/datatypes/#email-address) data type."), @AllowedValue(value="hostname", description="The [hostname](https://pages.nist.gov/metaschema/specification/datatypes/#hostname) data type."), @AllowedValue(value="integer", description="The [integer](https://pages.nist.gov/metaschema/specification/datatypes/#integer) data type."), @AllowedValue(value="ip-v4-address", description="The [ip-v4-address](https://pages.nist.gov/metaschema/specification/datatypes/#ip-v4-address) data type."), @AllowedValue(value="ip-v6-address", description="The [ip-v6-address](https://pages.nist.gov/metaschema/specification/datatypes/#ip-v6-address) data type."), @AllowedValue(value="non-negative-integer", description="The [non-negative-integer](https://pages.nist.gov/metaschema/specification/datatypes/#non-negative-integer) data type."), @AllowedValue(value="positive-integer", description="The [positive-integer](https://pages.nist.gov/metaschema/specification/datatypes/#positive-integer) data type."), @AllowedValue(value="string", description="The [string](https://pages.nist.gov/metaschema/specification/datatypes/#string) data type."), @AllowedValue(value="token", description="The [token](https://pages.nist.gov/metaschema/specification/datatypes/#token) data type."), @AllowedValue(value="uri", description="The [uri](https://pages.nist.gov/metaschema/specification/datatypes/#uri) data type."), @AllowedValue(value="uri-reference", description="The [uri-reference](https://pages.nist.gov/metaschema/specification/datatypes/#uri-reference) data type."), @AllowedValue(value="uuid", description="The [uuid](https://pages.nist.gov/metaschema/specification/datatypes/#uuid) data type."), @AllowedValue(value="base64Binary", description="An old name which is deprecated for use in favor of the 'base64' data type.", deprecatedVersion="1.0.0"), @AllowedValue(value="dateTime", description="An old name which is deprecated for use in favor of the 'date-time' data type.", deprecatedVersion="1.0.0"), @AllowedValue(value="dateTime-with-timezone", description="An old name which is deprecated for use in favor of the 'date-time-with-timezone' data type.", deprecatedVersion="1.0.0"), @AllowedValue(value="email", description="An old name which is deprecated for use in favor of the 'email-address' data type.", deprecatedVersion="1.0.0"), @AllowedValue(value="nonNegativeInteger", description="An old name which is deprecated for use in favor of the 'non-negative-integer' data type.", deprecatedVersion="1.0.0"), @AllowedValue(value="positiveInteger", description="An old name which is deprecated for use in favor of the 'positive-integer' data type.", deprecatedVersion="1.0.0")})}))
    private String _asType;
    @BoundFlag(formalName="Default Flag Value", name="default", typeAdapter=StringAdapter.class)
    private String _default;
    @BoundFlag(formalName="Is Flag Required?", name="required", defaultValue="no", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="yes", description="The flag is required."), @AllowedValue(value="no", description="The flag is optional.")})}))
    private String _required;
    @BoundField(formalName="Formal Name", description="A formal name for the data construct, to be presented in documentation.", useName="formal-name")
    private String _formalName;
    @BoundField(formalName="Description", description="A short description of the data construct's purpose, describing the constructs semantics.", useName="description", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _description;
    @BoundAssembly(formalName="Property", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(useName="constraint")
    private FlagConstraints _constraint;
    @BoundField(formalName="Remarks", description="Any explanatory or helpful information to be provided about the remarks parent.", useName="remarks")
    private Remarks _remarks;
    @BoundAssembly(formalName="Example", useName="example", maxOccurs=-1, groupAs=@GroupAs(name="examples", inJson=JsonGroupAsBehavior.LIST))
    private List<Example> _examples;

    public InlineDefineFlag() {
        this(null);
    }

    public InlineDefineFlag(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    public BigInteger getIndex() {
        return this._index;
    }

    public void setIndex(BigInteger value) {
        this._index = value;
    }

    public String getDeprecated() {
        return this._deprecated;
    }

    public void setDeprecated(String value) {
        this._deprecated = value;
    }

    public String getAsType() {
        return this._asType;
    }

    public void setAsType(String value) {
        this._asType = value;
    }

    public String getDefault() {
        return this._default;
    }

    public void setDefault(String value) {
        this._default = value;
    }

    public String getRequired() {
        return this._required;
    }

    public void setRequired(String value) {
        this._required = value;
    }

    public String getFormalName() {
        return this._formalName;
    }

    public void setFormalName(String value) {
        this._formalName = value;
    }

    public MarkupLine getDescription() {
        return this._description;
    }

    public void setDescription(MarkupLine value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public FlagConstraints getConstraint() {
        return this._constraint;
    }

    public void setConstraint(FlagConstraints value) {
        this._constraint = value;
    }

    public Remarks getRemarks() {
        return this._remarks;
    }

    public void setRemarks(Remarks value) {
        this._remarks = value;
    }

    public List<Example> getExamples() {
        return this._examples;
    }

    public void setExamples(List<Example> value) {
        this._examples = value;
    }

    public boolean addExample(Example item) {
        Example value = (Example)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._examples == null) {
            this._examples = new LinkedList<Example>();
        }
        return this._examples.add(value);
    }

    public boolean removeExample(Example item) {
        Example value = (Example)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._examples != null && this._examples.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

