/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.datatype.adapter.IntegerAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.math.BigInteger;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.LogicalLocation;
import org.schemastore.json.sarif.x210.Message;
import org.schemastore.json.sarif.x210.PhysicalLocation;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Location", description="A location within a programming artifact.", name="location", moduleClass=SarifModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="@id >= -1", message="The id '{ . }' is not greater than or equal to '-1'.")}))
public class Location
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Location Identifier", description="A value that distinguishes this location from all other locations within a single result object.", name="id", defaultValue="-1", typeAdapter=IntegerAdapter.class)
    private BigInteger _id;
    @BoundAssembly(formalName="Physical Location", description="A physical location relevant to a result. Specifies a reference to a programming artifact together with a range of bytes or characters within that artifact.", useName="physicalLocation")
    private PhysicalLocation _physicalLocation;
    @BoundAssembly(formalName="Logical Location", description="The logical locations associated with the result.", useName="logicalLocation")
    private LogicalLocation _logicalLocation;
    @BoundAssembly(formalName="Location Message", description="A message relevant to the location.", useName="message")
    private Message _message;

    public Location() {
        this(null);
    }

    public Location(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public BigInteger getId() {
        return this._id;
    }

    public void setId(BigInteger value) {
        this._id = value;
    }

    public PhysicalLocation getPhysicalLocation() {
        return this._physicalLocation;
    }

    public void setPhysicalLocation(PhysicalLocation value) {
        this._physicalLocation = value;
    }

    public LogicalLocation getLogicalLocation() {
        return this._logicalLocation;
    }

    public void setLogicalLocation(LogicalLocation value) {
        this._logicalLocation = value;
    }

    public Message getMessage() {
        return this._message;
    }

    public void setMessage(Message value) {
        this._message = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

