/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.datatype.adapter.IntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.NonNegativeIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.PositiveIntegerAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.math.BigInteger;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.Message;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Region", description="A region within an artifact where a result was detected.", name="region", moduleClass=SarifModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="exists(startLine|charOffset|byteOffset)", message="At least a startLine, charOffset, or byteOffset must be provided.")}))
public class Region
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="Start Line", description="The line number of the first character in the region.", useName="startLine", typeAdapter=PositiveIntegerAdapter.class)
    private BigInteger _startLine;
    @BoundField(formalName="Start Column", description="The column number of the first character in the region.", useName="startColumn", typeAdapter=PositiveIntegerAdapter.class)
    private BigInteger _startColumn;
    @BoundField(formalName="End Line", description="The line number of the last character in the region.", useName="endLine", typeAdapter=PositiveIntegerAdapter.class)
    private BigInteger _endLine;
    @BoundField(formalName="End Column", description="The column number of the character following the end of the region.", useName="endColumn", typeAdapter=PositiveIntegerAdapter.class)
    private BigInteger _endColumn;
    @BoundField(formalName="Character Offset", description="The zero-based offset from the beginning of the artifact of the first character in the region.", useName="charOffset", defaultValue="-1", typeAdapter=IntegerAdapter.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="@id >= -1", message="The offset '{ . }' is not greater than or equal to '-1'.")}))
    private BigInteger _charOffset;
    @BoundField(formalName="Character Length", description="The length of the region in characters.", useName="charLength", typeAdapter=NonNegativeIntegerAdapter.class)
    private BigInteger _charLength;
    @BoundField(formalName="Byte Offset", description="The zero-based offset from the beginning of the artifact of the first byte in the region", useName="byteOffset", defaultValue="-1", typeAdapter=IntegerAdapter.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="@id >= -1", message="The offset '{ . }' is not greater than or equal to '-1'.")}))
    private BigInteger _byteOffset;
    @BoundField(formalName="Byte Length", description="The length of the region in bytes.", useName="byteLength", typeAdapter=NonNegativeIntegerAdapter.class)
    private BigInteger _byteLength;
    @BoundAssembly(formalName="Region Message", description="A message relevant to the region.", useName="message")
    private Message _message;

    public Region() {
        this(null);
    }

    public Region(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public BigInteger getStartLine() {
        return this._startLine;
    }

    public void setStartLine(BigInteger value) {
        this._startLine = value;
    }

    public BigInteger getStartColumn() {
        return this._startColumn;
    }

    public void setStartColumn(BigInteger value) {
        this._startColumn = value;
    }

    public BigInteger getEndLine() {
        return this._endLine;
    }

    public void setEndLine(BigInteger value) {
        this._endLine = value;
    }

    public BigInteger getEndColumn() {
        return this._endColumn;
    }

    public void setEndColumn(BigInteger value) {
        this._endColumn = value;
    }

    public BigInteger getCharOffset() {
        return this._charOffset;
    }

    public void setCharOffset(BigInteger value) {
        this._charOffset = value;
    }

    public BigInteger getCharLength() {
        return this._charLength;
    }

    public void setCharLength(BigInteger value) {
        this._charLength = value;
    }

    public BigInteger getByteOffset() {
        return this._byteOffset;
    }

    public void setByteOffset(BigInteger value) {
        this._byteOffset = value;
    }

    public BigInteger getByteLength() {
        return this._byteLength;
    }

    public void setByteLength(BigInteger value) {
        this._byteLength = value;
    }

    public Message getMessage() {
        return this._message;
    }

    public void setMessage(Message value) {
        this._message = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

