/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.datatype.adapter.IntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.PositiveIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.ArtifactLocation;
import org.schemastore.json.sarif.x210.Location;
import org.schemastore.json.sarif.x210.Message;
import org.schemastore.json.sarif.x210.ReportingDescriptorReference;
import org.schemastore.json.sarif.x210.ResultProvenance;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Results", description="Results from the run of a tool.", name="result", moduleClass=SarifModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.ERROR, test="@ruleIndex >= -1", message="The value '{ . }' is not greater than or equal to '-1'.")}))
public class Result
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Rule Identifier", description="The stable, unique identifier of the rule, if any, to which this result is relevant.", name="ruleId", typeAdapter=StringAdapter.class)
    private String _ruleId;
    @BoundFlag(formalName="Rule Identifier", description="The stable, unique identifier of the rule, if any, to which this result is relevant.", name="ruleIndex", defaultValue="-1", typeAdapter=IntegerAdapter.class)
    private BigInteger _ruleIndex;
    @BoundFlag(formalName="Result Unique Identifier", description="A stable, unique identifier for the result.", name="guid", typeAdapter=UuidAdapter.class)
    private UUID _guid;
    @BoundAssembly(formalName="Reporting Descriptor Reference", description="A reference used to locate the rule descriptor relevant to this result.", useName="rule")
    private ReportingDescriptorReference _rule;
    @BoundField(formalName="Result Kind", description="A value that categorizes results by evaluation state.", useName="kind", defaultValue="fail", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="notApplicable", description=""), @AllowedValue(value="pass", description=""), @AllowedValue(value="fail", description=""), @AllowedValue(value="review", description=""), @AllowedValue(value="open", description=""), @AllowedValue(value="informational", description="")})}))
    private String _kind;
    @BoundField(formalName="Severity Level", description="A value specifying the severity level of the result.", useName="level", defaultValue="warning", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="none", description=""), @AllowedValue(value="note", description=""), @AllowedValue(value="warning", description=""), @AllowedValue(value="error", description="")})}))
    private String _level;
    @BoundAssembly(formalName="Result Message", description="A message that describes the result. The first sentence of the message only will be displayed when visible space is limited.", useName="message")
    private Message _message;
    @BoundAssembly(formalName="Scanned Artifact", description="Identifies the artifact that the analysis tool was instructed to scan. This need not be the same as the artifact where the result actually occurred.", useName="analysisTarget")
    private ArtifactLocation _analysisTarget;
    @BoundAssembly(formalName="Result Location", description="The set of locations where the result was detected. Specify only one location unless the problem indicated by the result can only be corrected by making a change at every specified location.", useName="location", maxOccurs=-1, groupAs=@GroupAs(name="locations", inJson=JsonGroupAsBehavior.LIST))
    private List<Location> _locations;
    @BoundField(formalName="Occurrence Count", description="A positive integer specifying the number of times this logically unique result was observed in this run.", useName="occurenceCount", typeAdapter=PositiveIntegerAdapter.class)
    private BigInteger _occurenceCount;
    @BoundAssembly(formalName="Result Related Location", description="A set of locations relevant to this result.", useName="relatedLocation")
    private Location _relatedLocation;
    @BoundAssembly(formalName="Result Provenance", description="Information about how and when the result was detected.", useName="provenance")
    private ResultProvenance _provenance;

    public Result() {
        this(null);
    }

    public Result(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getRuleId() {
        return this._ruleId;
    }

    public void setRuleId(String value) {
        this._ruleId = value;
    }

    public BigInteger getRuleIndex() {
        return this._ruleIndex;
    }

    public void setRuleIndex(BigInteger value) {
        this._ruleIndex = value;
    }

    public UUID getGuid() {
        return this._guid;
    }

    public void setGuid(UUID value) {
        this._guid = value;
    }

    public ReportingDescriptorReference getRule() {
        return this._rule;
    }

    public void setRule(ReportingDescriptorReference value) {
        this._rule = value;
    }

    public String getKind() {
        return this._kind;
    }

    public void setKind(String value) {
        this._kind = value;
    }

    public String getLevel() {
        return this._level;
    }

    public void setLevel(String value) {
        this._level = value;
    }

    public Message getMessage() {
        return this._message;
    }

    public void setMessage(Message value) {
        this._message = value;
    }

    public ArtifactLocation getAnalysisTarget() {
        return this._analysisTarget;
    }

    public void setAnalysisTarget(ArtifactLocation value) {
        this._analysisTarget = value;
    }

    public List<Location> getLocations() {
        return this._locations;
    }

    public void setLocations(List<Location> value) {
        this._locations = value;
    }

    public boolean addLocation(Location item) {
        Location value = (Location)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._locations == null) {
            this._locations = new LinkedList<Location>();
        }
        return this._locations.add(value);
    }

    public boolean removeLocation(Location item) {
        Location value = (Location)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._locations != null && this._locations.remove(value);
    }

    public BigInteger getOccurenceCount() {
        return this._occurenceCount;
    }

    public void setOccurenceCount(BigInteger value) {
        this._occurenceCount = value;
    }

    public Location getRelatedLocation() {
        return this._relatedLocation;
    }

    public void setRelatedLocation(Location value) {
        this._relatedLocation = value;
    }

    public ResultProvenance getProvenance() {
        return this._provenance;
    }

    public void setProvenance(ResultProvenance value) {
        this._provenance = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

