/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateTimeWithTZAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.PhysicalLocation;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(formalName="Result Provanance", description="Contains information about how and when a result was detected.", name="resultProvenance", moduleClass=SarifModule.class)
public class ResultProvenance
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="First Detection Time", description="The Coordinated Universal Time (UTC) date and time at which the result was first detected. See \\\\\"Date/time properties\\\\\" in the SARIF spec for the required format.", useName="firstDetectionTimeUtc", typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _firstDetectionTimeUtc;
    @BoundField(formalName="Last Detection Time", description="The Coordinated Universal Time (UTC) date and time at which the result was most recently detected. See \\\\\"Date/time properties\\\\\" in the SARIF spec for the required format.", useName="lastDetectionTimeUtc", typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _lastDetectionTimeUtc;
    @BoundAssembly(formalName="Conversion Source", description="An sequence of physicalLocation objects which specify the portions of an analysis tool's output that a converter transformed into the result.", useName="conversionSource", maxOccurs=-1, groupAs=@GroupAs(name="conversionSources", inJson=JsonGroupAsBehavior.LIST))
    private List<PhysicalLocation> _conversionSources;

    public ResultProvenance() {
        this(null);
    }

    public ResultProvenance(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public ZonedDateTime getFirstDetectionTimeUtc() {
        return this._firstDetectionTimeUtc;
    }

    public void setFirstDetectionTimeUtc(ZonedDateTime value) {
        this._firstDetectionTimeUtc = value;
    }

    public ZonedDateTime getLastDetectionTimeUtc() {
        return this._lastDetectionTimeUtc;
    }

    public void setLastDetectionTimeUtc(ZonedDateTime value) {
        this._lastDetectionTimeUtc = value;
    }

    public List<PhysicalLocation> getConversionSources() {
        return this._conversionSources;
    }

    public void setConversionSources(List<PhysicalLocation> value) {
        this._conversionSources = value;
    }

    public boolean addConversionSource(PhysicalLocation item) {
        PhysicalLocation value = (PhysicalLocation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._conversionSources == null) {
            this._conversionSources = new LinkedList<PhysicalLocation>();
        }
        return this._conversionSources.add(value);
    }

    public boolean removeConversionSource(PhysicalLocation item) {
        PhysicalLocation value = (PhysicalLocation)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._conversionSources != null && this._conversionSources.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

