/*
 * Decompiled with CFR 0.152.
 */
package org.schemastore.json.sarif.x210;

import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.schemastore.json.sarif.x210.ReportingDescriptor;
import org.schemastore.json.sarif.x210.SarifModule;

@MetaschemaAssembly(name="toolComponent", moduleClass=SarifModule.class)
public class ToolComponent
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Tool Component Unique Identifier", description="A stable, unique identifier for the tool component.", name="guid", typeAdapter=UuidAdapter.class)
    private UUID _guid;
    @BoundField(formalName="Tool Component Name", description="The name of the tool component.", useName="name")
    private String _name;
    @BoundField(formalName="Tool Component Organization", description="The organization or company that produced the tool component.", useName="organization")
    private String _organization;
    @BoundField(formalName="Tool Component Product", description="A product suite to which the tool component belongs.", useName="product")
    private String _product;
    @BoundField(formalName="Tool Component Version", description="The tool component version, in whatever format the component natively provides.", useName="version")
    private String _version;
    @BoundField(formalName="Tool Component Semantic Version", description="The tool component version in the format specified by Semantic Versioning 2.0.", useName="semanticVersion")
    private String _semanticVersion;
    @BoundField(formalName="Tool Component Information URI", description="The absolute URI at which information about this version of the tool component can be found.", useName="informationUri", typeAdapter=UriAdapter.class)
    private URI _informationUri;
    @BoundAssembly(formalName="Rule", description="An array of reportingDescriptor objects relevant to the analysis performed by the tool component.", useName="rule", maxOccurs=-1, groupAs=@GroupAs(name="rules", inJson=JsonGroupAsBehavior.LIST))
    private List<ReportingDescriptor> _rules;

    public ToolComponent() {
        this(null);
    }

    public ToolComponent(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getGuid() {
        return this._guid;
    }

    public void setGuid(UUID value) {
        this._guid = value;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    public String getOrganization() {
        return this._organization;
    }

    public void setOrganization(String value) {
        this._organization = value;
    }

    public String getProduct() {
        return this._product;
    }

    public void setProduct(String value) {
        this._product = value;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String value) {
        this._version = value;
    }

    public String getSemanticVersion() {
        return this._semanticVersion;
    }

    public void setSemanticVersion(String value) {
        this._semanticVersion = value;
    }

    public URI getInformationUri() {
        return this._informationUri;
    }

    public void setInformationUri(URI value) {
        this._informationUri = value;
    }

    public List<ReportingDescriptor> getRules() {
        return this._rules;
    }

    public void setRules(List<ReportingDescriptor> value) {
        this._rules = value;
    }

    public boolean addRule(ReportingDescriptor item) {
        ReportingDescriptor value = (ReportingDescriptor)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._rules == null) {
            this._rules = new LinkedList<ReportingDescriptor>();
        }
        return this._rules.add(value);
    }

    public boolean removeRule(ReportingDescriptor item) {
        ReportingDescriptor value = (ReportingDescriptor)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._rules != null && this._rules.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

