/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.impl.AbstractBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.impl.DefinitionAssembly;
import gov.nist.secauto.metaschema.databind.model.impl.DefinitionField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public abstract class AbstractModuleLoaderStrategy
implements IBindingContext.IModuleLoaderStrategy {
    @NonNull
    private final Map<IBoundDefinitionModelAssembly, IBindingContext.IBindingMatcher> bindingMatchers = new HashMap<IBoundDefinitionModelAssembly, IBindingContext.IBindingMatcher>();
    @NonNull
    private final Map<IModule, IBoundModule> moduleToBoundModuleMap = new ConcurrentHashMap<IModule, IBoundModule>();
    @NonNull
    private final Map<Class<? extends IBoundModule>, IBoundModule> modulesByClass = new HashMap<Class<? extends IBoundModule>, IBoundModule>();
    @NonNull
    private final Lock modulesLock = new ReentrantLock();
    @NonNull
    private final Map<Class<? extends IBoundObject>, IBoundDefinitionModelComplex> definitionsByClass = new HashMap<Class<? extends IBoundObject>, IBoundDefinitionModelComplex>();
    @NonNull
    private final Lock definitionsLock = new ReentrantLock();

    @Override
    public IBoundModule loadModule(@NonNull Class<? extends IBoundModule> clazz, @NonNull IBindingContext bindingContext) {
        return this.lookupInstance(clazz, bindingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBoundModule registerModule(IModule module, IBindingContext bindingContext) {
        this.modulesLock.lock();
        try {
            IBoundModule iBoundModule = (IBoundModule)ObjectUtils.notNull((Object)this.moduleToBoundModuleMap.computeIfAbsent(module, key -> {
                IBoundModule boundModule;
                assert (key != null);
                if (key instanceof IBoundModule) {
                    boundModule = (IBoundModule)key;
                } else {
                    Class<? extends IBoundModule> moduleClass = this.handleUnboundModule((IModule)key);
                    boundModule = this.lookupInstance(moduleClass, bindingContext);
                }
                boundModule.getExportedAssemblyDefinitions().forEach(assembly -> {
                    assert (assembly != null);
                    if (assembly.isRoot()) {
                        this.registerBindingMatcher((IBoundDefinitionModelAssembly)assembly);
                    }
                });
                return boundModule;
            }));
            return iBoundModule;
        }
        finally {
            this.modulesLock.unlock();
        }
    }

    @NonNull
    protected abstract Class<? extends IBoundModule> handleUnboundModule(@NonNull IModule var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected IBoundModule lookupInstance(@NonNull Class<? extends IBoundModule> moduleClass, @NonNull IBindingContext bindingContext) {
        IBoundModule retval;
        this.modulesLock.lock();
        try {
            retval = this.modulesByClass.get(moduleClass);
            if (retval == null) {
                if (!moduleClass.isAnnotationPresent(MetaschemaModule.class)) {
                    throw new IllegalStateException(String.format("The class '%s' is missing the '%s' annotation", moduleClass.getCanonicalName(), MetaschemaModule.class.getCanonicalName()));
                }
                retval = IBoundModule.newInstance(moduleClass, bindingContext, this.getImportedModules(moduleClass, bindingContext));
                this.modulesByClass.put(moduleClass, retval);
            }
        }
        finally {
            this.modulesLock.unlock();
        }
        return retval;
    }

    @NonNull
    protected IBindingContext.IBindingMatcher registerBindingMatcher(@NonNull IBoundDefinitionModelAssembly definition) {
        IBindingContext.IBindingMatcher retval;
        this.modulesLock.lock();
        try {
            retval = this.bindingMatchers.get(definition);
            if (retval == null) {
                if (!definition.isRoot()) {
                    throw new IllegalArgumentException(String.format("The provided definition '%s' is not a root assembly.", definition.getBoundClass().getName()));
                }
                retval = IBindingContext.IBindingMatcher.of(definition);
                this.bindingMatchers.put(definition, retval);
            }
        }
        finally {
            this.modulesLock.unlock();
        }
        return retval;
    }

    public final List<IBindingContext.IBindingMatcher> getBindingMatchers() {
        this.modulesLock.lock();
        try {
            ArrayList<IBindingContext.IBindingMatcher> arrayList = new ArrayList<IBindingContext.IBindingMatcher>(this.bindingMatchers.values());
            return arrayList;
        }
        finally {
            this.modulesLock.unlock();
        }
    }

    @NonNull
    private List<IBoundModule> getImportedModules(@NonNull Class<? extends IBoundModule> moduleClass, @NonNull IBindingContext bindingContext) {
        MetaschemaModule moduleAnnotation = moduleClass.getAnnotation(MetaschemaModule.class);
        return (List)ObjectUtils.notNull(Arrays.stream(moduleAnnotation.imports()).map(clazz -> this.lookupInstance((Class)ObjectUtils.requireNonNull((Object)clazz), bindingContext)).collect(Collectors.toUnmodifiableList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBoundDefinitionModelComplex getBoundDefinitionForClass(@NonNull Class<? extends IBoundObject> clazz, @NonNull IBindingContext bindingContext) {
        this.definitionsLock.lock();
        try {
            IBoundDefinitionModelComplex retval = this.definitionsByClass.get(clazz);
            if (retval == null) {
                retval = this.newBoundDefinition(clazz, bindingContext);
                this.definitionsByClass.put(clazz, retval);
            }
            IBoundDefinitionModelComplex iBoundDefinitionModelComplex = retval;
            return iBoundDefinitionModelComplex;
        }
        finally {
            this.definitionsLock.unlock();
        }
    }

    @NonNull
    private IBoundDefinitionModelComplex newBoundDefinition(@NonNull Class<? extends IBoundObject> clazz, @NonNull IBindingContext bindingContext) {
        AbstractBoundDefinitionModelComplex retval;
        if (clazz.isAnnotationPresent(MetaschemaAssembly.class)) {
            MetaschemaAssembly annotation = ModelUtil.getAnnotation(clazz, MetaschemaAssembly.class);
            Class<? extends IBoundModule> moduleClass = annotation.moduleClass();
            IBoundModule module = this.loadModule(moduleClass, bindingContext);
            retval = DefinitionAssembly.newInstance(clazz, annotation, module, bindingContext);
        } else if (clazz.isAnnotationPresent(MetaschemaField.class)) {
            MetaschemaField annotation = ModelUtil.getAnnotation(clazz, MetaschemaField.class);
            Class<? extends IBoundModule> moduleClass = annotation.moduleClass();
            IBoundModule module = this.loadModule(moduleClass, bindingContext);
            retval = DefinitionField.newInstance(clazz, annotation, module, bindingContext);
        } else {
            throw new IllegalArgumentException(String.format("Unable to find bound definition for class '%s'.", clazz.getName()));
        }
        return retval;
    }
}

