/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.SimpleModuleLoaderStrategy;
import gov.nist.secauto.metaschema.databind.io.AbstractDeserializer;
import gov.nist.secauto.metaschema.databind.io.AbstractSerializer;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.IDeserializer;
import gov.nist.secauto.metaschema.databind.io.ISerializer;
import gov.nist.secauto.metaschema.databind.io.json.DefaultJsonDeserializer;
import gov.nist.secauto.metaschema.databind.io.json.DefaultJsonSerializer;
import gov.nist.secauto.metaschema.databind.io.xml.DefaultXmlDeserializer;
import gov.nist.secauto.metaschema.databind.io.xml.DefaultXmlSerializer;
import gov.nist.secauto.metaschema.databind.io.yaml.DefaultYamlDeserializer;
import gov.nist.secauto.metaschema.databind.io.yaml.DefaultYamlSerializer;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.BindingModuleLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingModuleLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.ModuleLoadingPostProcessor;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.METASCHEMA;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

public class DefaultBindingContext
implements IBindingContext {
    private static Lazy<DefaultBindingContext> singleton = Lazy.lazy(DefaultBindingContext::new);
    @NonNull
    private final IBindingContext.IModuleLoaderStrategy moduleLoaderStrategy;
    @NonNull
    private final Map<Class<?>, IBoundDefinitionModelComplex> boundClassToStrategyMap = new ConcurrentHashMap();

    @NonNull
    static DefaultBindingContext instance() {
        return (DefaultBindingContext)ObjectUtils.notNull((Object)((DefaultBindingContext)singleton.get()));
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public DefaultBindingContext() {
        this(new SimpleModuleLoaderStrategy());
    }

    public DefaultBindingContext(@NonNull IBindingContext.IModuleLoaderStrategy strategy) {
        this.moduleLoaderStrategy = strategy;
        this.registerModule(MetaschemaModelModule.class);
    }

    @Override
    @NonNull
    public final IBindingContext.IModuleLoaderStrategy getModuleLoaderStrategy() {
        return this.moduleLoaderStrategy;
    }

    @Override
    public IBindingModuleLoader newModuleLoader() {
        return new ModuleLoader(this, this.getModuleLoaderStrategy());
    }

    @Override
    @NonNull
    public final IBoundModule registerModule(@NonNull Class<? extends IBoundModule> clazz) {
        IBindingContext.IModuleLoaderStrategy strategy = this.getModuleLoaderStrategy();
        IBoundModule module = strategy.loadModule(clazz, this);
        strategy.registerModule((IModule)module, this);
        return module;
    }

    @NonNull
    protected Collection<IBindingContext.IBindingMatcher> getBindingMatchers() {
        return this.getModuleLoaderStrategy().getBindingMatchers();
    }

    @Override
    public final IBoundDefinitionModelComplex registerClassBinding(IBoundDefinitionModelComplex definition) {
        Class clazz = definition.getBoundClass();
        return this.boundClassToStrategyMap.computeIfAbsent(clazz, k -> definition);
    }

    @Override
    public final IBoundDefinitionModelComplex getBoundDefinitionForClass(@NonNull Class<? extends IBoundObject> clazz) {
        return this.moduleLoaderStrategy.getBoundDefinitionForClass(clazz, this);
    }

    @Override
    public <CLASS extends IBoundObject> ISerializer<CLASS> newSerializer(@NonNull Format format, @NonNull Class<CLASS> clazz) {
        AbstractSerializer retval;
        IBoundDefinitionModelAssembly definition;
        Objects.requireNonNull(format, "format");
        try {
            definition = (IBoundDefinitionModelAssembly)IBoundDefinitionModelAssembly.class.cast(this.getBoundDefinitionForClass(clazz));
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(String.format("Class '%s' is not a bound assembly.", clazz.getClass().getName()), ex);
        }
        if (definition == null) {
            throw new IllegalStateException(String.format("Class '%s' is not bound", clazz.getClass().getName()));
        }
        switch (format) {
            case JSON: {
                retval = new DefaultJsonSerializer(definition);
                break;
            }
            case XML: {
                retval = new DefaultXmlSerializer(definition);
                break;
            }
            case YAML: {
                retval = new DefaultYamlSerializer(definition);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported format '%s'", new Object[]{format}));
            }
        }
        return retval;
    }

    @Override
    public <CLASS extends IBoundObject> IDeserializer<CLASS> newDeserializer(@NonNull Format format, @NonNull Class<CLASS> clazz) {
        AbstractDeserializer retval;
        IBoundDefinitionModelAssembly definition;
        try {
            definition = (IBoundDefinitionModelAssembly)IBoundDefinitionModelAssembly.class.cast(this.getBoundDefinitionForClass(clazz));
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(String.format("Class '%s' is not a bound assembly.", clazz.getClass().getName()), ex);
        }
        if (definition == null) {
            throw new IllegalStateException(String.format("Class '%s' is not bound", clazz.getName()));
        }
        switch (format) {
            case JSON: {
                retval = new DefaultJsonDeserializer(definition);
                break;
            }
            case XML: {
                retval = new DefaultXmlDeserializer(definition);
                break;
            }
            case YAML: {
                retval = new DefaultYamlDeserializer(definition);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported format '%s'", new Object[]{format}));
            }
        }
        return retval;
    }

    @Override
    public Class<? extends IBoundObject> getBoundClassForRootXmlQName(@NonNull QName rootQName) {
        IBindingContext.IBindingMatcher matcher;
        Class<? extends IBoundObject> retval = null;
        Iterator<IBindingContext.IBindingMatcher> iterator = this.getBindingMatchers().iterator();
        while (iterator.hasNext() && (retval = (matcher = iterator.next()).getBoundClassForXmlQName(rootQName)) == null) {
        }
        return retval;
    }

    @Override
    public Class<? extends IBoundObject> getBoundClassForRootJsonName(@NonNull String rootName) {
        IBindingContext.IBindingMatcher matcher;
        Class<? extends IBoundObject> retval = null;
        Iterator<IBindingContext.IBindingMatcher> iterator = this.getBindingMatchers().iterator();
        while (iterator.hasNext() && (retval = (matcher = iterator.next()).getBoundClassForJsonName(rootName)) == null) {
        }
        return retval;
    }

    @Override
    public <CLASS extends IBoundObject> CLASS deepCopy(@NonNull CLASS other, IBoundObject parentInstance) throws BindingException {
        IBoundDefinitionModelComplex definition = this.getBoundDefinitionForClass(other.getClass());
        if (definition == null) {
            throw new IllegalStateException(String.format("Class '%s' is not bound", other.getClass().getName()));
        }
        return (CLASS)((IBoundObject)ObjectUtils.asType(definition.deepCopyItem(other, parentInstance)));
    }

    private static class ModuleLoader
    extends BindingModuleLoader {
        public ModuleLoader(@NonNull IBindingContext bindingContext, @NonNull ModuleLoadingPostProcessor postProcessor) {
            super(bindingContext, postProcessor);
        }

        public IBindingMetaschemaModule load(URI resource) throws MetaschemaException, IOException {
            IBindingMetaschemaModule module = (IBindingMetaschemaModule)super.load(resource);
            this.getBindingContext().registerModule((IModule)module);
            return module;
        }

        public IBindingMetaschemaModule load(Path path) throws MetaschemaException, IOException {
            IBindingMetaschemaModule module = (IBindingMetaschemaModule)super.load(path);
            this.getBindingContext().registerModule((IModule)module);
            return module;
        }

        public IBindingMetaschemaModule load(URL url) throws MetaschemaException, IOException {
            IBindingMetaschemaModule module = (IBindingMetaschemaModule)super.load(url);
            this.getBindingContext().registerModule((IModule)module);
            return module;
        }

        @Override
        protected IBindingMetaschemaModule newModule(URI resource, METASCHEMA binding, List<? extends IBindingMetaschemaModule> importedModules) throws MetaschemaException {
            return super.newModule(resource, binding, importedModules);
        }
    }
}

