/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.datatype.DataTypeService;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.metapath.DynamicContext;
import gov.nist.secauto.metaschema.core.metapath.IDocumentLoader;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDefinitionNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IRootAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IConstraintLoader;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.IModuleLoader;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.constraint.DefaultConstraintValidator;
import gov.nist.secauto.metaschema.core.model.constraint.ExternalConstraintsModulePostProcessor;
import gov.nist.secauto.metaschema.core.model.constraint.FindingCollectingConstraintValidationHandler;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintValidationHandler;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintValidator;
import gov.nist.secauto.metaschema.core.model.constraint.ValidationFeature;
import gov.nist.secauto.metaschema.core.model.validation.AggregateValidationResult;
import gov.nist.secauto.metaschema.core.model.validation.IValidationResult;
import gov.nist.secauto.metaschema.core.model.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.core.model.validation.XmlSchemaContentValidator;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.DefaultBindingContext;
import gov.nist.secauto.metaschema.databind.PostProcessingModuleLoaderStrategy;
import gov.nist.secauto.metaschema.databind.RootAssemblyBindingMatcher;
import gov.nist.secauto.metaschema.databind.SimpleModuleLoaderStrategy;
import gov.nist.secauto.metaschema.databind.codegen.DefaultModuleBindingGenerator;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.io.DefaultBoundLoader;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import gov.nist.secauto.metaschema.databind.io.IDeserializer;
import gov.nist.secauto.metaschema.databind.io.ISerializer;
import gov.nist.secauto.metaschema.databind.io.yaml.YamlOperations;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.BindingConstraintLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingModuleLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.ModuleLoadingPostProcessor;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xml.sax.SAXException;

public interface IBindingContext {
    public static BindingContextBuilder builder() {
        return new BindingContextBuilder();
    }

    @NonNull
    public static IBindingContext newInstance() {
        return new DefaultBindingContext();
    }

    @NonNull
    public static IBindingContext newInstance(@NonNull IModuleLoaderStrategy strategy) {
        return new DefaultBindingContext(strategy);
    }

    @NonNull
    public IModuleLoaderStrategy getModuleLoaderStrategy();

    @NonNull
    public IBindingModuleLoader newModuleLoader();

    @NonNull
    default public IBindingMetaschemaModule loadMetaschema(@NonNull Path path) throws MetaschemaException, IOException {
        return (IBindingMetaschemaModule)this.newModuleLoader().load(path);
    }

    @NonNull
    default public IBindingMetaschemaModule loadMetaschema(@NonNull URL url) throws MetaschemaException, IOException {
        return (IBindingMetaschemaModule)this.newModuleLoader().load(url);
    }

    @NonNull
    public static IConstraintLoader getConstraintLoader() {
        return new BindingConstraintLoader(DefaultBindingContext.instance());
    }

    @NonNull
    default public IConstraintLoader newConstraintLoader() {
        return new BindingConstraintLoader(this);
    }

    @NonNull
    public IBoundModule registerModule(@NonNull Class<? extends IBoundModule> var1);

    @NonNull
    default public IBoundModule registerModule(@NonNull IModule module) {
        return this.getModuleLoaderStrategy().registerModule(module, this);
    }

    @Nullable
    public IBoundDefinitionModelComplex registerClassBinding(@NonNull IBoundDefinitionModelComplex var1);

    @Nullable
    public IBoundDefinitionModelComplex getBoundDefinitionForClass(@NonNull Class<? extends IBoundObject> var1);

    @Nullable
    public Class<? extends IBoundObject> getBoundClassForRootXmlQName(@NonNull QName var1);

    @Nullable
    public Class<? extends IBoundObject> getBoundClassForRootJsonName(@NonNull String var1);

    @Nullable
    default public <TYPE extends IDataTypeAdapter<?>> TYPE getJavaTypeAdapterInstance(@NonNull Class<TYPE> clazz) {
        return (TYPE)DataTypeService.getInstance().getJavaTypeAdapterByClass(clazz);
    }

    @NonNull
    public <CLASS extends IBoundObject> ISerializer<CLASS> newSerializer(@NonNull Format var1, @NonNull Class<CLASS> var2);

    @NonNull
    public <CLASS extends IBoundObject> IDeserializer<CLASS> newDeserializer(@NonNull Format var1, @NonNull Class<CLASS> var2);

    @NonNull
    default public IBoundLoader newBoundLoader() {
        return new DefaultBoundLoader(this);
    }

    @NonNull
    public <CLASS extends IBoundObject> CLASS deepCopy(@NonNull CLASS var1, IBoundObject var2) throws BindingException;

    default public IConstraintValidator newValidator(@NonNull IConstraintValidationHandler handler, @Nullable IConfiguration<ValidationFeature<?>> config) {
        IBoundLoader loader = this.newBoundLoader();
        loader.disableFeature(DeserializationFeature.DESERIALIZE_VALIDATE_CONSTRAINTS);
        DynamicContext context = new DynamicContext();
        context.setDocumentLoader((IDocumentLoader)loader);
        DefaultConstraintValidator retval = new DefaultConstraintValidator(handler);
        if (config != null) {
            retval.applyConfiguration(config);
        }
        return retval;
    }

    default public IValidationResult validate(@NonNull IDocumentNodeItem nodeItem, @NonNull IBoundLoader loader, @Nullable IConfiguration<ValidationFeature<?>> config) {
        IRootAssemblyNodeItem root = nodeItem.getRootAssemblyNodeItem();
        return this.validate((IDefinitionNodeItem<?, ?>)root, loader, config);
    }

    default public IValidationResult validate(@NonNull IDefinitionNodeItem<?, ?> nodeItem, @NonNull IBoundLoader loader, @Nullable IConfiguration<ValidationFeature<?>> config) {
        FindingCollectingConstraintValidationHandler handler = new FindingCollectingConstraintValidationHandler();
        IConstraintValidator validator = this.newValidator((IConstraintValidationHandler)handler, config);
        DynamicContext dynamicContext = new DynamicContext(nodeItem.getStaticContext());
        dynamicContext.setDocumentLoader((IDocumentLoader)loader);
        validator.validate(nodeItem, dynamicContext);
        validator.finalizeValidation(dynamicContext);
        return handler;
    }

    default public IValidationResult validate(@NonNull URI target, @NonNull Format asFormat, @NonNull ISchemaValidationProvider schemaProvider, @Nullable IConfiguration<ValidationFeature<?>> config) throws IOException {
        IValidationResult retval = schemaProvider.validateWithSchema(target, asFormat, this);
        if (retval.isPassing()) {
            IValidationResult constraintValidationResult = this.validateWithConstraints(target, config);
            retval = AggregateValidationResult.aggregate((IValidationResult[])new IValidationResult[]{retval, constraintValidationResult});
        }
        return retval;
    }

    default public IValidationResult validateWithConstraints(@NonNull URI target, @Nullable IConfiguration<ValidationFeature<?>> config) throws IOException {
        IBoundLoader loader = this.newBoundLoader();
        loader.disableFeature(DeserializationFeature.DESERIALIZE_VALIDATE_CONSTRAINTS);
        IDocumentNodeItem nodeItem = loader.loadAsNodeItem(target);
        return this.validate(nodeItem, loader, config);
    }

    public static final class BindingContextBuilder {
        private Path compilePath;
        private final List<IModuleLoader.IModulePostProcessor> postProcessors = new LinkedList<IModuleLoader.IModulePostProcessor>();
        private final List<IConstraintSet> constraintSets = new LinkedList<IConstraintSet>();
        @NonNull
        private final Function<IModuleLoaderStrategy, IBindingContext> initializer;

        private BindingContextBuilder() {
            this(DefaultBindingContext::new);
        }

        public BindingContextBuilder(@NonNull Function<IModuleLoaderStrategy, IBindingContext> initializer) {
            this.initializer = initializer;
        }

        @NonNull
        public BindingContextBuilder compilePath(@NonNull Path path) {
            this.compilePath = path;
            return this;
        }

        @NonNull
        public BindingContextBuilder postProcessor(@NonNull IModuleLoader.IModulePostProcessor processor) {
            this.postProcessors.add(processor);
            return this;
        }

        @NonNull
        public BindingContextBuilder constraintSet(@NonNull IConstraintSet set) {
            this.constraintSets.add(set);
            return this;
        }

        @NonNull
        public BindingContextBuilder constraintSet(@NonNull Collection<IConstraintSet> set) {
            this.constraintSets.addAll(set);
            return this;
        }

        @NonNull
        public IBindingContext build() {
            IModuleLoaderStrategy strategy = this.compilePath == null ? new SimpleModuleLoaderStrategy() : new SimpleModuleLoaderStrategy(new DefaultModuleBindingGenerator(this.compilePath));
            LinkedList<IModuleLoader.IModulePostProcessor> processors = new LinkedList<IModuleLoader.IModulePostProcessor>(this.postProcessors);
            if (!this.constraintSets.isEmpty()) {
                processors.add((IModuleLoader.IModulePostProcessor)new ExternalConstraintsModulePostProcessor(this.constraintSets));
            }
            if (!processors.isEmpty()) {
                strategy = new PostProcessingModuleLoaderStrategy(CollectionUtil.unmodifiableList(processors), strategy);
            }
            return (IBindingContext)ObjectUtils.notNull((Object)this.initializer.apply(strategy));
        }
    }

    public static interface IModuleLoaderStrategy
    extends ModuleLoadingPostProcessor {
        @NonNull
        public IBoundModule loadModule(@NonNull Class<? extends IBoundModule> var1, @NonNull IBindingContext var2);

        @Override
        default public void postProcessModule(@NonNull IModule module, @NonNull IBindingContext bindingContext) {
        }

        @NonNull
        public IBoundModule registerModule(@NonNull IModule var1, @NonNull IBindingContext var2);

        @NonNull
        public Collection<IBindingMatcher> getBindingMatchers();

        @NonNull
        public IBoundDefinitionModelComplex getBoundDefinitionForClass(@NonNull Class<? extends IBoundObject> var1, @NonNull IBindingContext var2);
    }

    public static interface ISchemaValidationProvider {
        @NonNull
        default public IValidationResult validateWithSchema(@NonNull URI target, @NonNull Format asFormat, @NonNull IBindingContext bindingContext) throws FileNotFoundException, IOException {
            IValidationResult retval;
            URL targetResource = (URL)ObjectUtils.notNull((Object)target.toURL());
            switch (asFormat) {
                case JSON: {
                    JSONObject json;
                    try (BufferedInputStream is = new BufferedInputStream((InputStream)ObjectUtils.notNull((Object)targetResource.openStream()));){
                        json = new JSONObject(new JSONTokener((InputStream)is));
                    }
                    retval = this.getJsonSchema(json, bindingContext).validate(json, target);
                    break;
                }
                case XML: {
                    try {
                        retval = this.getXmlSchemas(targetResource, bindingContext).validate(target);
                        break;
                    }
                    catch (SAXException ex) {
                        throw new IOException(ex);
                    }
                }
                case YAML: {
                    JSONObject json = YamlOperations.yamlToJson(YamlOperations.parseYaml(target));
                    if (!1.$assertionsDisabled && json == null) {
                        throw new AssertionError();
                    }
                    retval = this.getJsonSchema(json, bindingContext).validate(json, (URI)ObjectUtils.notNull((Object)target));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported format: " + asFormat.name());
                }
            }
            return retval;
        }

        @NonNull
        public JsonSchemaContentValidator getJsonSchema(@NonNull JSONObject var1, @NonNull IBindingContext var2) throws IOException;

        @NonNull
        public XmlSchemaContentValidator getXmlSchemas(@NonNull URL var1, @NonNull IBindingContext var2) throws IOException, SAXException;

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    public static interface IBindingMatcher {
        @NonNull
        public static IBindingMatcher of(IBoundDefinitionModelAssembly assembly) {
            if (!assembly.isRoot()) {
                throw new IllegalArgumentException(String.format("The provided class '%s' is not a root assembly.", assembly.getBoundClass().getName()));
            }
            return new RootAssemblyBindingMatcher(assembly);
        }

        public Class<? extends IBoundObject> getBoundClassForXmlQName(QName var1);

        public Class<? extends IBoundObject> getBoundClassForJsonName(String var1);
    }
}

