/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.IModuleLoader;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.SimpleModuleLoaderStrategy;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PostProcessingModuleLoaderStrategy
implements IBindingContext.IModuleLoaderStrategy {
    @NonNull
    private final List<IModuleLoader.IModulePostProcessor> modulePostProcessors;
    private final IBindingContext.IModuleLoaderStrategy delegate;
    private final Set<IModule> postProcessedModules = new HashSet<IModule>();
    private final Lock postProcessedModulesLock = new ReentrantLock();

    public PostProcessingModuleLoaderStrategy(@NonNull List<IModuleLoader.IModulePostProcessor> modulePostProcessors) {
        this(modulePostProcessors, new SimpleModuleLoaderStrategy());
    }

    public PostProcessingModuleLoaderStrategy(@NonNull List<IModuleLoader.IModulePostProcessor> modulePostProcessors, @NonNull IBindingContext.IModuleLoaderStrategy delegate) {
        this.modulePostProcessors = CollectionUtil.unmodifiableList(new ArrayList<IModuleLoader.IModulePostProcessor>(modulePostProcessors));
        this.delegate = delegate;
    }

    @NonNull
    protected List<IModuleLoader.IModulePostProcessor> getModulePostProcessors() {
        return this.modulePostProcessors;
    }

    @Override
    public IBoundModule loadModule(Class<? extends IBoundModule> clazz, IBindingContext bindingContext) {
        return this.delegate.loadModule(clazz, bindingContext);
    }

    @Override
    public void postProcessModule(IModule module, IBindingContext bindingContext) {
        this.processModule(module);
        this.delegate.postProcessModule(module, bindingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBoundModule registerModule(IModule module, IBindingContext bindingContext) {
        IBoundModule boundModule;
        this.postProcessedModulesLock.lock();
        try {
            this.processModule(module);
            boundModule = this.delegate.registerModule(module, bindingContext);
            this.postProcessedModules.add((IModule)boundModule);
        }
        finally {
            this.postProcessedModulesLock.unlock();
        }
        return boundModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processModule(@NonNull IModule module) {
        this.postProcessedModulesLock.lock();
        try {
            if (!this.postProcessedModules.contains(module)) {
                if (!(module instanceof MetaschemaModelModule)) {
                    for (IModuleLoader.IModulePostProcessor postProcessor : this.getModulePostProcessors()) {
                        postProcessor.processModule(module);
                    }
                }
                this.postProcessedModules.add(module);
            }
        }
        finally {
            this.postProcessedModulesLock.unlock();
        }
    }

    @Override
    public Collection<IBindingContext.IBindingMatcher> getBindingMatchers() {
        return this.delegate.getBindingMatchers();
    }

    @Override
    public IBoundDefinitionModelComplex getBoundDefinitionForClass(Class<? extends IBoundObject> clazz, IBindingContext bindingContext) {
        return this.delegate.getBoundDefinitionForClass(clazz, bindingContext);
    }
}

