/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.MetapathException;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedModuleClass;
import gov.nist.secauto.metaschema.databind.codegen.IModuleBindingGenerator;
import gov.nist.secauto.metaschema.databind.codegen.IProduction;
import gov.nist.secauto.metaschema.databind.codegen.ModuleCompilerHelper;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import java.io.IOException;
import java.nio.file.Path;

public class DefaultModuleBindingGenerator
implements IModuleBindingGenerator {
    @NonNull
    private final Path compilePath;

    public DefaultModuleBindingGenerator(@NonNull Path compilePath) {
        this.compilePath = compilePath;
    }

    @Override
    public Class<? extends IBoundModule> generate(IModule module) {
        IProduction production;
        ClassLoader classLoader = ModuleCompilerHelper.newClassLoader(this.compilePath, (ClassLoader)ObjectUtils.notNull((Object)Thread.currentThread().getContextClassLoader()));
        try {
            production = ModuleCompilerHelper.compileMetaschema(module, this.compilePath);
        }
        catch (IOException ex) {
            throw new MetapathException(String.format("Unable to generate and compile classes for module '%s'.", module.getLocation()), (Throwable)ex);
        }
        try {
            return ((IGeneratedModuleClass)ObjectUtils.notNull((Object)production.getModuleProduction(module))).load(classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

