/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedDefinitionClass;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedModuleClass;
import gov.nist.secauto.metaschema.databind.codegen.PackageMetadata;
import gov.nist.secauto.metaschema.databind.codegen.ProductionImpl;
import gov.nist.secauto.metaschema.databind.codegen.config.IBindingConfiguration;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IMetaschemaClassFactory;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.ITypeResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Stream;

public interface IProduction {
    @NonNull
    public Collection<IGeneratedModuleClass> getModuleProductions();

    @Nullable
    public IGeneratedModuleClass getModuleProduction(@NonNull IModule var1);

    @NonNull
    public Collection<IGeneratedDefinitionClass> getGlobalDefinitionClasses();

    @NonNull
    public Stream<? extends IGeneratedClass> getGeneratedClasses();

    @NonNull
    public static IProduction of(@NonNull Collection<? extends IModule> modules, @NonNull IBindingConfiguration bindingConfiguration, @NonNull Path classDir) throws IOException {
        ITypeResolver typeResolver = ITypeResolver.newTypeResolver(bindingConfiguration);
        IMetaschemaClassFactory classFactory = IMetaschemaClassFactory.newInstance(typeResolver);
        ProductionImpl retval = new ProductionImpl();
        for (IModule iModule : modules) {
            if (!1.$assertionsDisabled && iModule == null) {
                throw new AssertionError();
            }
            retval.addModule(iModule, classFactory, classDir);
        }
        HashMap<String, PackageMetadata> packageNameToPackageMetadataMap = new HashMap<String, PackageMetadata>();
        for (IGeneratedModuleClass moduleProduction : retval.getModuleProductions()) {
            String packageName = moduleProduction.getPackageName();
            PackageMetadata metadata = (PackageMetadata)packageNameToPackageMetadataMap.get(packageName);
            if (metadata == null) {
                metadata = new PackageMetadata(moduleProduction);
                packageNameToPackageMetadataMap.put(metadata.getPackageName(), metadata);
                continue;
            }
            metadata.addModule(moduleProduction);
        }
        for (PackageMetadata metadata : packageNameToPackageMetadataMap.values()) {
            if (!1.$assertionsDisabled && metadata == null) {
                throw new AssertionError();
            }
            retval.addPackage(metadata, classFactory, classDir);
        }
        return retval;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

