/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaCompilerSupport {
    private static final Logger LOGGER = LogManager.getLogger(JavaCompilerSupport.class);
    @NonNull
    private final Path classDir;
    @NonNull
    private final Set<String> classPath = new LinkedHashSet<String>();
    @NonNull
    private final Set<String> modulePath = new LinkedHashSet<String>();
    @NonNull
    private final Set<String> rootModuleNames = new LinkedHashSet<String>();

    public JavaCompilerSupport(@NonNull Path classDir) {
        this.classDir = classDir;
    }

    public Set<String> getClassPath() {
        return this.classPath;
    }

    public Set<String> getModulePath() {
        return this.modulePath;
    }

    public Set<String> getRootModuleNames() {
        return this.rootModuleNames;
    }

    public void addToClassPath(@NonNull String entry) {
        this.classPath.add(entry);
    }

    public void addToModulePath(@NonNull String entry) {
        this.modulePath.add(entry);
    }

    public void addRootModule(@NonNull String entry) {
        this.rootModuleNames.add(entry);
    }

    @NonNull
    protected List<String> generateCompilerOptions() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-d");
        options.add(this.classDir.toString());
        if (!this.classPath.isEmpty()) {
            options.add("-classpath");
            options.add(this.classPath.stream().collect(Collectors.joining(":")));
        }
        if (!this.modulePath.isEmpty()) {
            options.add("-p");
            options.add(this.modulePath.stream().collect(Collectors.joining(":")));
        }
        return options;
    }

    public CompilationResult compile(@NonNull List<Path> classFiles, @Nullable Writer compileOut) throws IOException {
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            List compilationUnits = classFiles.stream().map(xva$0 -> fileManager.getJavaFileObjects((Path)xva$0)).map(CollectionUtil::toList).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
            List<String> options = this.generateCompilerOptions();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("Using options: {}", options);
            }
            JavaCompiler.CompilationTask task = compiler.getTask(compileOut, fileManager, diagnostics, options, null, compilationUnits);
            task.addModules(this.rootModuleNames);
            CompilationResult compilationResult = new CompilationResult(task.call(), diagnostics);
            return compilationResult;
        }
    }

    public static final class CompilationResult {
        private final boolean successful;
        @NonNull
        private final DiagnosticCollector<JavaFileObject> diagnostics;

        private CompilationResult(boolean successful, @NonNull DiagnosticCollector<JavaFileObject> diagnostics) {
            this.successful = successful;
            this.diagnostics = diagnostics;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public DiagnosticCollector<?> getDiagnostics() {
            return this.diagnostics;
        }
    }
}

