/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.databind.codegen.IProduction;
import gov.nist.secauto.metaschema.databind.codegen.config.IBindingConfiguration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JavaGenerator {
    private static final Logger LOGGER = LogManager.getLogger(JavaGenerator.class);

    private JavaGenerator() {
    }

    @NonNull
    public static IProduction generate(@NonNull IModule module, @NonNull Path targetDir, @NonNull IBindingConfiguration bindingConfiguration) throws IOException {
        return JavaGenerator.generate(CollectionUtil.singletonList((Object)module), targetDir, bindingConfiguration);
    }

    @NonNull
    public static IProduction generate(@NonNull Collection<? extends IModule> modules, @NonNull Path targetDirectory, @NonNull IBindingConfiguration bindingConfiguration) throws IOException {
        Objects.requireNonNull(modules, "metaschemas");
        Objects.requireNonNull(targetDirectory, "generationTargetDirectory");
        Objects.requireNonNull(bindingConfiguration, "bindingConfiguration");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Generating Java classes in: {}", (Object)targetDirectory);
        }
        return IProduction.of(modules, bindingConfiguration, targetDirectory);
    }
}

