/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.databind.codegen.IProduction;
import gov.nist.secauto.metaschema.databind.codegen.JavaCompilerSupport;
import gov.nist.secauto.metaschema.databind.codegen.JavaGenerator;
import gov.nist.secauto.metaschema.databind.codegen.config.DefaultBindingConfiguration;
import gov.nist.secauto.metaschema.databind.codegen.config.IBindingConfiguration;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jdt.annotation.Owning;

public final class ModuleCompilerHelper {
    private static final Logger LOGGER = LogManager.getLogger(ModuleCompilerHelper.class);

    private ModuleCompilerHelper() {
    }

    @Owning
    @NonNull
    public static ClassLoader newClassLoader(@NonNull Path classDir, @NonNull ClassLoader parent) {
        return (ClassLoader)ObjectUtils.notNull((Object)AccessController.doPrivileged(() -> {
            try {
                return new URLClassLoader(new URL[]{classDir.toUri().toURL()}, parent);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("unable to configure class loader", ex);
            }
        }));
    }

    @NonNull
    public static IProduction compileMetaschema(@NonNull IModule module, @NonNull Path classDir) throws IOException {
        return ModuleCompilerHelper.compileModule(module, classDir, new DefaultBindingConfiguration());
    }

    @NonNull
    public static IProduction compileModule(@NonNull IModule module, @NonNull Path classDir, @NonNull IBindingConfiguration bindingConfiguration) throws IOException {
        JavaCompilerSupport.CompilationResult result;
        ModuleDescriptor descriptor;
        IProduction production = JavaGenerator.generate(module, classDir, bindingConfiguration);
        List classesToCompile = production.getGeneratedClasses().collect(Collectors.toList());
        List classes = (List)ObjectUtils.notNull(classesToCompile.stream().map(IGeneratedClass::getClassFile).collect(Collectors.toUnmodifiableList()));
        JavaCompilerSupport compiler = new JavaCompilerSupport(classDir);
        boolean usingModule = false;
        Module databindModule = IBindingContext.class.getModule();
        if (databindModule != null && (descriptor = databindModule.getDescriptor()) != null) {
            compiler.addRootModule((String)ObjectUtils.notNull((Object)descriptor.name()));
            usingModule = true;
        }
        String classPath = System.getProperty("java.class.path");
        String modulePath = System.getProperty("jdk.module.path");
        if (usingModule) {
            if (classPath != null) {
                Arrays.stream(classPath.split(":")).forEachOrdered(compiler::addToClassPath);
            }
            if (modulePath != null) {
                Arrays.stream(modulePath.split(":")).forEachOrdered(compiler::addToModulePath);
            }
        } else {
            if (classPath != null) {
                Arrays.stream(classPath.split(":")).forEachOrdered(compiler::addToClassPath);
            }
            if (modulePath != null) {
                Arrays.stream(modulePath.split(":")).forEachOrdered(compiler::addToClassPath);
            }
        }
        if (!(result = compiler.compile(classes, null)).isSuccessful()) {
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(diagnostics.getDiagnostics().toString());
            }
            throw new IllegalStateException(String.format("failed to compile classes: %s%nClasspath: %s%nModule Path: %s%n%s", classesToCompile.stream().map(clazz -> clazz.getClassName().canonicalName()).collect(Collectors.joining(",")), diagnostics.getDiagnostics().toString(), compiler.getClassPath().stream().collect(Collectors.joining(":")), compiler.getModulePath().stream().collect(Collectors.joining(":"))));
        }
        return production;
    }
}

