/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedModuleClass;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;

class PackageMetadata {
    @NonNull
    private final String packageName;
    @NonNull
    private final URI xmlNamespace;
    @NonNull
    private final List<IGeneratedModuleClass> moduleProductions = new LinkedList<IGeneratedModuleClass>();

    public PackageMetadata(@NonNull IGeneratedModuleClass moduleProduction) {
        this.packageName = moduleProduction.getPackageName();
        this.xmlNamespace = moduleProduction.getModule().getXmlNamespace();
        this.moduleProductions.add(moduleProduction);
    }

    @NonNull
    protected String getPackageName() {
        return this.packageName;
    }

    @NonNull
    protected URI getXmlNamespace() {
        return this.xmlNamespace;
    }

    @NonNull
    protected List<IGeneratedModuleClass> getModuleProductions() {
        return this.moduleProductions;
    }

    public void addModule(@NonNull IGeneratedModuleClass moduleProduction) {
        URI nextXmlNamespace = moduleProduction.getModule().getXmlNamespace();
        if (!this.xmlNamespace.equals(nextXmlNamespace)) {
            throw new IllegalStateException(String.format("The package %s is associated with the XML namespaces '%s' and '%s'. A package must be associated with a single XML namespace.", this.getPackageName(), this.getXmlNamespace().toASCIIString(), nextXmlNamespace.toASCIIString()));
        }
        this.moduleProductions.add(moduleProduction);
    }
}

