/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedDefinitionClass;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedModuleClass;
import gov.nist.secauto.metaschema.databind.codegen.IPackageProduction;
import gov.nist.secauto.metaschema.databind.codegen.IProduction;
import gov.nist.secauto.metaschema.databind.codegen.PackageMetadata;
import gov.nist.secauto.metaschema.databind.codegen.PackageProductionImpl;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IMetaschemaClassFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ProductionImpl
implements IProduction {
    @NonNull
    private final Map<IModule, IGeneratedModuleClass> moduleToProductionMap = new HashMap<IModule, IGeneratedModuleClass>();
    @NonNull
    private final Map<String, IPackageProduction> packageNameToProductionMap = new HashMap<String, IPackageProduction>();

    ProductionImpl() {
    }

    public void addModule(@NonNull IModule module, @NonNull IMetaschemaClassFactory classFactory, @NonNull Path targetDirectory) throws IOException {
        for (IModule importedModule : module.getImportedModules()) {
            assert (importedModule != null);
            this.addModule(importedModule, classFactory, targetDirectory);
        }
        if (this.moduleToProductionMap.get(module) == null) {
            IGeneratedModuleClass metaschemaClass = classFactory.generateClass(module, targetDirectory);
            this.moduleToProductionMap.put(module, metaschemaClass);
        }
    }

    protected IPackageProduction addPackage(@NonNull PackageMetadata metadata, @NonNull IMetaschemaClassFactory classFactory, @NonNull Path targetDirectory) throws IOException {
        String javaPackage = metadata.getPackageName();
        PackageProductionImpl retval = new PackageProductionImpl(metadata, classFactory, targetDirectory);
        this.packageNameToProductionMap.put(javaPackage, retval);
        return retval;
    }

    @Override
    public Collection<IGeneratedModuleClass> getModuleProductions() {
        return Collections.unmodifiableCollection(this.moduleToProductionMap.values());
    }

    @NonNull
    protected Collection<IPackageProduction> getPackageProductions() {
        return Collections.unmodifiableCollection(this.packageNameToProductionMap.values());
    }

    @Override
    public IGeneratedModuleClass getModuleProduction(IModule module) {
        return this.moduleToProductionMap.get(module);
    }

    public List<IGeneratedDefinitionClass> getGlobalDefinitionClasses() {
        return (List)ObjectUtils.notNull(this.getModuleProductions().stream().flatMap(metaschema -> metaschema.getGeneratedDefinitionClasses().stream()).collect(Collectors.toUnmodifiableList()));
    }

    @Override
    public Stream<? extends IGeneratedClass> getGeneratedClasses() {
        return (Stream)ObjectUtils.notNull(Stream.concat(this.getModuleProductions().stream().flatMap(module -> Stream.concat(Stream.of(module), module.getGeneratedDefinitionClasses().stream())), this.getPackageProductions().stream().flatMap(javaPackage -> Stream.of(javaPackage.getGeneratedClass()))));
    }
}

