/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.impl;

import com.squareup.javapoet.AnnotationSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.metapath.DynamicContext;
import gov.nist.secauto.metaschema.core.metapath.ISequence;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDefinitionNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItemFactory;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.INamedInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.ICardinalityConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IIndexConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IKeyField;
import gov.nist.secauto.metaschema.core.model.constraint.ILet;
import gov.nist.secauto.metaschema.core.model.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IUniqueConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.Let;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AnnotationGenerator {
    private static final Logger LOGGER = LogManager.getLogger(AnnotationGenerator.class);

    private AnnotationGenerator() {
    }

    public static Object getDefaultValue(Class<?> annotation, String member) {
        Object retval;
        Method method;
        try {
            method = annotation.getDeclaredMethod(member, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            retval = method.getDefaultValue();
        }
        catch (TypeNotPresentException ex) {
            retval = null;
        }
        return retval;
    }

    private static void buildConstraint(Class<?> annotationType, AnnotationSpec.Builder annotation, IConstraint constraint) {
        MarkupLine description;
        String formalName;
        String id = constraint.getId();
        if (id != null) {
            annotation.addMember("id", "$S", new Object[]{id});
        }
        if ((formalName = constraint.getFormalName()) != null) {
            annotation.addMember("formalName", "$S", new Object[]{formalName});
        }
        if ((description = constraint.getDescription()) != null) {
            annotation.addMember("description", "$S", new Object[]{description.toMarkdown()});
        }
        annotation.addMember("level", "$T.$L", new Object[]{IConstraint.Level.class, constraint.getLevel()});
        String target = constraint.getTarget();
        if (!target.equals(AnnotationGenerator.getDefaultValue(annotationType, "target"))) {
            annotation.addMember("target", "$S", new Object[]{target});
        }
    }

    public static void buildValueConstraints(@NonNull AnnotationSpec.Builder builder, @NonNull IFlagDefinition definition) {
        Map lets = definition.getLetExpressions();
        if (!lets.isEmpty() || !definition.getConstraints().isEmpty()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(ValueConstraints.class);
            assert (annotation != null);
            AnnotationGenerator.applyLetAssignments(annotation, lets);
            AnnotationGenerator.applyAllowedValuesConstraints(annotation, definition.getAllowedValuesConstraints());
            AnnotationGenerator.applyIndexHasKeyConstraints(annotation, definition.getIndexHasKeyConstraints());
            AnnotationGenerator.applyMatchesConstraints(annotation, definition.getMatchesConstraints());
            AnnotationGenerator.applyExpectConstraints(annotation, definition.getExpectConstraints());
            builder.addMember("valueConstraints", "$L", new Object[]{annotation.build()});
        }
    }

    public static void buildValueConstraints(@NonNull AnnotationSpec.Builder builder, @NonNull IModelDefinition definition) {
        Map lets = definition.getLetExpressions();
        List allowedValues = definition.getAllowedValuesConstraints();
        List indexHasKey = definition.getIndexHasKeyConstraints();
        List matches = definition.getMatchesConstraints();
        List expects = definition.getExpectConstraints();
        if (!(lets.isEmpty() && allowedValues.isEmpty() && indexHasKey.isEmpty() && matches.isEmpty() && expects.isEmpty())) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(ValueConstraints.class);
            assert (annotation != null);
            AnnotationGenerator.applyLetAssignments(annotation, lets);
            AnnotationGenerator.applyAllowedValuesConstraints(annotation, allowedValues);
            AnnotationGenerator.applyIndexHasKeyConstraints(annotation, indexHasKey);
            AnnotationGenerator.applyMatchesConstraints(annotation, matches);
            AnnotationGenerator.applyExpectConstraints(annotation, expects);
            builder.addMember("valueConstraints", "$L", new Object[]{annotation.build()});
        }
    }

    public static void buildAssemblyConstraints(@NonNull AnnotationSpec.Builder builder, @NonNull IAssemblyDefinition definition) {
        List index = definition.getIndexConstraints();
        List unique = definition.getUniqueConstraints();
        List cardinality = definition.getHasCardinalityConstraints();
        if (!(index.isEmpty() && unique.isEmpty() && cardinality.isEmpty())) {
            AnnotationSpec.Builder annotation = (AnnotationSpec.Builder)ObjectUtils.notNull((Object)AnnotationSpec.builder(AssemblyConstraints.class));
            AnnotationGenerator.applyIndexConstraints(annotation, index);
            AnnotationGenerator.applyUniqueConstraints(annotation, unique);
            AnnotationGenerator.applyHasCardinalityConstraints(definition, annotation, cardinality);
            builder.addMember("modelConstraints", "$L", new Object[]{annotation.build()});
        }
    }

    private static void applyLetAssignments(@NonNull AnnotationSpec.Builder annotation, @NonNull Map<QName, ? extends ILet> lets) {
        for (ILet iLet : lets.values()) {
            AnnotationSpec.Builder letAnnotation = AnnotationSpec.builder(Let.class);
            letAnnotation.addMember("name", "$S", new Object[]{iLet.getName()});
            letAnnotation.addMember("target", "$S", new Object[]{iLet.getValueExpression().getPath()});
            MarkupMultiline remarks = iLet.getRemarks();
            if (remarks != null) {
                letAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("lets", "$L", new Object[]{letAnnotation.build()});
        }
    }

    private static void applyAllowedValuesConstraints(@NonNull AnnotationSpec.Builder annotation, @NonNull List<? extends IAllowedValuesConstraint> constraints) {
        for (IAllowedValuesConstraint iAllowedValuesConstraint : constraints) {
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(AllowedValues.class);
            AnnotationGenerator.buildConstraint(AllowedValues.class, constraintAnnotation, (IConstraint)iAllowedValuesConstraint);
            boolean isAllowedOther = iAllowedValuesConstraint.isAllowedOther();
            if (isAllowedOther != (Boolean)AnnotationGenerator.getDefaultValue(AllowedValues.class, "allowOthers")) {
                constraintAnnotation.addMember("allowOthers", "$L", new Object[]{isAllowedOther});
            }
            for (IAllowedValue value : iAllowedValuesConstraint.getAllowedValues().values()) {
                AnnotationSpec.Builder valueAnnotation = AnnotationSpec.builder(AllowedValue.class);
                valueAnnotation.addMember("value", "$S", new Object[]{value.getValue()});
                valueAnnotation.addMember("description", "$S", new Object[]{value.getDescription().toMarkdown()});
                String deprecatedVersion = value.getDeprecatedVersion();
                if (deprecatedVersion != null) {
                    valueAnnotation.addMember("deprecatedVersion", "$S", new Object[]{deprecatedVersion});
                }
                constraintAnnotation.addMember("values", "$L", new Object[]{valueAnnotation.build()});
            }
            MarkupMultiline remarks = iAllowedValuesConstraint.getRemarks();
            if (remarks != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("allowedValues", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyIndexHasKeyConstraints(@NonNull AnnotationSpec.Builder annotation, @NonNull List<? extends IIndexHasKeyConstraint> constraints) {
        for (IIndexHasKeyConstraint iIndexHasKeyConstraint : constraints) {
            MarkupMultiline remarks;
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(IndexHasKey.class);
            AnnotationGenerator.buildConstraint(IndexHasKey.class, constraintAnnotation, (IConstraint)iIndexHasKeyConstraint);
            constraintAnnotation.addMember("indexName", "$S", new Object[]{iIndexHasKeyConstraint.getIndexName()});
            AnnotationGenerator.buildKeyFields(constraintAnnotation, iIndexHasKeyConstraint.getKeyFields());
            String message = iIndexHasKeyConstraint.getMessage();
            if (message != null) {
                constraintAnnotation.addMember("message", "$S", new Object[]{message});
            }
            if ((remarks = iIndexHasKeyConstraint.getRemarks()) != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("indexHasKey", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void buildKeyFields(@NonNull AnnotationSpec.Builder constraintAnnotation, @NonNull List<? extends IKeyField> keyFields) {
        for (IKeyField iKeyField : keyFields) {
            MarkupMultiline remarks;
            Pattern pattern;
            AnnotationSpec.Builder keyAnnotation = AnnotationSpec.builder(KeyField.class);
            String target = iKeyField.getTarget();
            if (!target.equals(AnnotationGenerator.getDefaultValue(KeyField.class, "target"))) {
                keyAnnotation.addMember("target", "$S", new Object[]{target});
            }
            if ((pattern = iKeyField.getPattern()) != null) {
                keyAnnotation.addMember("pattern", "$S", new Object[]{pattern.pattern()});
            }
            if ((remarks = iKeyField.getRemarks()) != null) {
                keyAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            constraintAnnotation.addMember("keyFields", "$L", new Object[]{keyAnnotation.build()});
        }
    }

    private static void applyMatchesConstraints(@NonNull AnnotationSpec.Builder annotation, @NonNull List<? extends IMatchesConstraint> constraints) {
        for (IMatchesConstraint iMatchesConstraint : constraints) {
            MarkupMultiline remarks;
            String message;
            IDataTypeAdapter dataType;
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(Matches.class);
            AnnotationGenerator.buildConstraint(Matches.class, constraintAnnotation, (IConstraint)iMatchesConstraint);
            Pattern pattern = iMatchesConstraint.getPattern();
            if (pattern != null) {
                constraintAnnotation.addMember("pattern", "$S", new Object[]{pattern.pattern()});
            }
            if ((dataType = iMatchesConstraint.getDataType()) != null) {
                constraintAnnotation.addMember("typeAdapter", "$T.class", new Object[]{dataType.getClass()});
            }
            if ((message = iMatchesConstraint.getMessage()) != null) {
                constraintAnnotation.addMember("message", "$S", new Object[]{message});
            }
            if ((remarks = iMatchesConstraint.getRemarks()) != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("matches", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyExpectConstraints(@NonNull AnnotationSpec.Builder annotation, @NonNull List<? extends IExpectConstraint> constraints) {
        for (IExpectConstraint iExpectConstraint : constraints) {
            MarkupMultiline remarks;
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(Expect.class);
            AnnotationGenerator.buildConstraint(Expect.class, constraintAnnotation, (IConstraint)iExpectConstraint);
            constraintAnnotation.addMember("test", "$S", new Object[]{iExpectConstraint.getTest()});
            if (iExpectConstraint.getMessage() != null) {
                constraintAnnotation.addMember("message", "$S", new Object[]{iExpectConstraint.getMessage()});
            }
            if ((remarks = iExpectConstraint.getRemarks()) != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("expect", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyIndexConstraints(@NonNull AnnotationSpec.Builder annotation, @NonNull List<? extends IIndexConstraint> constraints) {
        for (IIndexConstraint iIndexConstraint : constraints) {
            MarkupMultiline remarks;
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(Index.class);
            AnnotationGenerator.buildConstraint(Index.class, constraintAnnotation, (IConstraint)iIndexConstraint);
            constraintAnnotation.addMember("name", "$S", new Object[]{iIndexConstraint.getName()});
            AnnotationGenerator.buildKeyFields(constraintAnnotation, iIndexConstraint.getKeyFields());
            String message = iIndexConstraint.getMessage();
            if (message != null) {
                constraintAnnotation.addMember("message", "$S", new Object[]{message});
            }
            if ((remarks = iIndexConstraint.getRemarks()) != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("index", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyUniqueConstraints(@NonNull AnnotationSpec.Builder annotation, @NonNull List<? extends IUniqueConstraint> constraints) {
        for (IUniqueConstraint iUniqueConstraint : constraints) {
            MarkupMultiline remarks;
            AnnotationSpec.Builder constraintAnnotation = (AnnotationSpec.Builder)ObjectUtils.notNull((Object)AnnotationSpec.builder(IsUnique.class));
            AnnotationGenerator.buildConstraint(IsUnique.class, constraintAnnotation, (IConstraint)iUniqueConstraint);
            AnnotationGenerator.buildKeyFields(constraintAnnotation, iUniqueConstraint.getKeyFields());
            String message = iUniqueConstraint.getMessage();
            if (message != null) {
                constraintAnnotation.addMember("message", "$S", new Object[]{message});
            }
            if ((remarks = iUniqueConstraint.getRemarks()) != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("unique", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void checkCardinalities(@NonNull IAssemblyDefinition definition, @NonNull ICardinalityConstraint constraint, @NonNull ISequence<? extends IDefinitionNodeItem<?, ?>> instanceSet, @NonNull LogBuilder logBuilder) {
        LogBuilder warn = LOGGER.atWarn();
        for (IDefinitionNodeItem item : instanceSet.getValue()) {
            INamedInstance instance = item.getInstance();
            if (instance instanceof INamedModelInstanceAbsolute) {
                INamedModelInstanceAbsolute modelInstance = (INamedModelInstanceAbsolute)instance;
                AnnotationGenerator.checkMinOccurs(definition, constraint, modelInstance, logBuilder);
                AnnotationGenerator.checkMaxOccurs(definition, constraint, modelInstance, logBuilder);
                continue;
            }
            warn.log(String.format("Definition '%s' has min-occurs=%d cardinality constraint targeting '%s' that is not a model instance", definition.getName(), constraint.getMinOccurs(), constraint.getTarget()));
        }
    }

    private static void checkMinOccurs(@NonNull IAssemblyDefinition definition, @NonNull ICardinalityConstraint constraint, @NonNull INamedModelInstanceAbsolute modelInstance, @NonNull LogBuilder logBuilder) {
        Integer minOccurs = constraint.getMinOccurs();
        if (minOccurs != null) {
            if (minOccurs.intValue() == modelInstance.getMinOccurs()) {
                logBuilder.log(String.format("Definition '%s' has min-occurs=%d cardinality constraint targeting '%s' that is redundant with a targeted instance named '%s' that requires min-occurs=%d", definition.getName(), minOccurs, constraint.getTarget(), modelInstance.getName(), modelInstance.getMinOccurs()));
            } else if (minOccurs < modelInstance.getMinOccurs()) {
                logBuilder.log(String.format("Definition '%s' has min-occurs=%d cardinality constraint targeting '%s' that conflicts with a targeted instance named '%s' that requires min-occurs=%d", definition.getName(), minOccurs, constraint.getTarget(), modelInstance.getName(), modelInstance.getMinOccurs()));
            }
        }
    }

    private static void checkMaxOccurs(@NonNull IAssemblyDefinition definition, @NonNull ICardinalityConstraint constraint, @NonNull INamedModelInstanceAbsolute modelInstance, @NonNull LogBuilder logBuilder) {
        Integer maxOccurs = constraint.getMaxOccurs();
        if (maxOccurs != null) {
            if (maxOccurs.intValue() == modelInstance.getMaxOccurs()) {
                logBuilder.log(String.format("Definition '%s' has max-occurs=%d cardinality constraint targeting '%s' that is redundant with a targeted instance named '%s' that requires max-occurs=%d", definition.getName(), maxOccurs, constraint.getTarget(), modelInstance.getName(), modelInstance.getMaxOccurs()));
            } else if (maxOccurs < modelInstance.getMaxOccurs()) {
                logBuilder.log(String.format("Definition '%s' has max-occurs=%d cardinality constraint targeting '%s' that conflicts with a targeted instance named '%s' that requires max-occurs=%d", definition.getName(), maxOccurs, constraint.getTarget(), modelInstance.getName(), modelInstance.getMaxOccurs()));
            }
        }
    }

    private static void applyHasCardinalityConstraints(@NonNull IAssemblyDefinition definition, @NonNull AnnotationSpec.Builder annotation, @NonNull List<? extends ICardinalityConstraint> constraints) {
        DynamicContext dynamicContext = new DynamicContext();
        dynamicContext.disablePredicateEvaluation();
        for (ICardinalityConstraint iCardinalityConstraint : constraints) {
            Integer maxOccurs;
            IAssemblyNodeItem definitionNodeItem = INodeItemFactory.instance().newAssemblyNodeItem(definition);
            ISequence instanceSet = iCardinalityConstraint.matchTargets((IDefinitionNodeItem)definitionNodeItem, dynamicContext);
            if (LOGGER.isWarnEnabled()) {
                AnnotationGenerator.checkCardinalities(definition, iCardinalityConstraint, instanceSet, (LogBuilder)ObjectUtils.notNull((Object)LOGGER.atWarn()));
            }
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(HasCardinality.class);
            AnnotationGenerator.buildConstraint(HasCardinality.class, constraintAnnotation, (IConstraint)iCardinalityConstraint);
            Integer minOccurs = iCardinalityConstraint.getMinOccurs();
            if (minOccurs != null && !minOccurs.equals(AnnotationGenerator.getDefaultValue(HasCardinality.class, "minOccurs"))) {
                constraintAnnotation.addMember("minOccurs", "$L", new Object[]{minOccurs});
            }
            if ((maxOccurs = iCardinalityConstraint.getMaxOccurs()) != null && !maxOccurs.equals(AnnotationGenerator.getDefaultValue(HasCardinality.class, "maxOccurs"))) {
                constraintAnnotation.addMember("maxOccurs", "$L", new Object[]{maxOccurs});
            }
            annotation.addMember("cardinality", "$L", new Object[]{constraintAnnotation.build()});
            MarkupMultiline remarks = iCardinalityConstraint.getRemarks();
            if (remarks == null) continue;
            constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
        }
    }
}

