/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.typeinfo;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IChoiceGroupTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IGroupedNamedModelInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.ITypeResolver;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.TypeInfoUtils;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGroupedNamedModelInstanceTypeInfo<I extends INamedModelInstanceGrouped>
implements IGroupedNamedModelInstanceTypeInfo {
    @NonNull
    private final I instance;
    @NonNull
    private final IChoiceGroupTypeInfo parentTypeInfo;

    protected AbstractGroupedNamedModelInstanceTypeInfo(@NonNull I instance, @NonNull IChoiceGroupTypeInfo parentTypeInfo) {
        this.instance = instance;
        this.parentTypeInfo = parentTypeInfo;
    }

    protected abstract Class<? extends Annotation> getBindingAnnotation();

    protected abstract void applyInstanceAnnotation(@NonNull AnnotationSpec.Builder var1, @NonNull AnnotationSpec.Builder var2);

    @NonNull
    protected I getInstance() {
        return this.instance;
    }

    protected IChoiceGroupTypeInfo getChoiceGroupTypeInfo() {
        return this.parentTypeInfo;
    }

    @Override
    public Set<IModelDefinition> generateMemberAnnotation(@NonNull AnnotationSpec.Builder choiceGroupAnnotation, @NonNull TypeSpec.Builder typeBuilder, boolean requireExtension) {
        ClassName itemTypeName;
        AnnotationSpec.Builder memberAnnotation = (AnnotationSpec.Builder)ObjectUtils.notNull((Object)AnnotationSpec.builder(this.getBindingAnnotation()));
        TypeInfoUtils.buildCommonBindingAnnotationValues(this.getInstance(), memberAnnotation);
        LinkedHashSet<IModelDefinition> retval = new LinkedHashSet<IModelDefinition>();
        I instance = this.getInstance();
        IModelDefinition definition = this.getInstance().getDefinition();
        IChoiceGroupTypeInfo choiceGroupTypeInfo = this.getChoiceGroupTypeInfo();
        ITypeResolver typeResolver = choiceGroupTypeInfo.getParentTypeInfo().getTypeResolver();
        if (definition.isInline()) {
            itemTypeName = typeResolver.getClassName(definition);
            retval.add(definition);
        } else if (requireExtension) {
            ClassName extendedClassName = typeResolver.getClassName(definition);
            itemTypeName = typeResolver.getSubclassName(choiceGroupTypeInfo.getParentTypeInfo().getClassName(), (String)ObjectUtils.notNull((Object)StringUtils.capitalize((String)instance.getEffectiveDisciminatorValue())), definition);
            TypeSpec.Builder subClass = TypeSpec.classBuilder((ClassName)itemTypeName);
            subClass.superclass((TypeName)extendedClassName);
            subClass.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            typeBuilder.addType(subClass.build());
        } else {
            itemTypeName = typeResolver.getClassName(definition);
        }
        memberAnnotation.addMember("binding", "$T.class", new Object[]{itemTypeName});
        this.applyInstanceAnnotation(memberAnnotation, choiceGroupAnnotation);
        return retval;
    }
}

