/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.typeinfo;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IGroupable;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.AbstractInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IModelInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IAssemblyDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class AbstractModelInstanceTypeInfo<INSTANCE extends IModelInstanceAbsolute>
extends AbstractInstanceTypeInfo<INSTANCE, IAssemblyDefinitionTypeInfo>
implements IModelInstanceTypeInfo {
    protected AbstractModelInstanceTypeInfo(@NonNull INSTANCE instance, @NonNull IAssemblyDefinitionTypeInfo parentDefinition) {
        super(instance, parentDefinition);
    }

    @Override
    public String getBaseName() {
        IModelInstanceAbsolute instance = (IModelInstanceAbsolute)this.getInstance();
        String baseName = ((IModelInstanceAbsolute)this.getInstance()).getGroupAsName();
        if (baseName == null) {
            throw new IllegalStateException(String.format("Unable to derive the property name, due to missing group as name, for '%s' in the module '%s'.", instance.toCoordinates(), instance.getContainingModule().getLocation()));
        }
        return baseName;
    }

    @Override
    @NonNull
    public TypeName getJavaFieldType() {
        TypeName item = this.getJavaItemType();
        IModelInstanceAbsolute instance = (IModelInstanceAbsolute)this.getInstance();
        int maxOccurance = instance.getMaxOccurs();
        TypeName retval = maxOccurance == -1 || maxOccurance > 1 ? (JsonGroupAsBehavior.KEYED.equals((Object)instance.getJsonGroupAsBehavior()) ? (TypeName)ObjectUtils.notNull((Object)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), item})) : (TypeName)ObjectUtils.notNull((Object)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{item}))) : item;
        return retval;
    }

    @NonNull
    protected abstract AnnotationSpec.Builder newBindingAnnotation();

    @Override
    public Set<IModelDefinition> buildField(TypeSpec.Builder typeBuilder, FieldSpec.Builder fieldBuilder) {
        LinkedHashSet<IModelDefinition> retval = new LinkedHashSet<IModelDefinition>(super.buildField(typeBuilder, fieldBuilder));
        AnnotationSpec.Builder annotation = this.newBindingAnnotation();
        retval.addAll(this.buildBindingAnnotation(typeBuilder, fieldBuilder, annotation));
        fieldBuilder.addAnnotation(annotation.build());
        return retval;
    }

    @NonNull
    protected AnnotationSpec.Builder generateGroupAsAnnotation() {
        AnnotationSpec.Builder groupAsAnnoation = AnnotationSpec.builder(GroupAs.class);
        IModelInstanceAbsolute modelInstance = (IModelInstanceAbsolute)this.getInstance();
        groupAsAnnoation.addMember("name", "$S", new Object[]{ObjectUtils.requireNonNull((Object)modelInstance.getGroupAsName(), (String)"The grouping name must be non-null")});
        JsonGroupAsBehavior jsonGroupAsBehavior = modelInstance.getJsonGroupAsBehavior();
        assert (jsonGroupAsBehavior != null);
        if (!IGroupable.DEFAULT_JSON_GROUP_AS_BEHAVIOR.equals((Object)jsonGroupAsBehavior)) {
            groupAsAnnoation.addMember("inJson", "$T.$L", new Object[]{JsonGroupAsBehavior.class, jsonGroupAsBehavior.toString()});
        }
        XmlGroupAsBehavior xmlGroupAsBehavior = modelInstance.getXmlGroupAsBehavior();
        assert (xmlGroupAsBehavior != null);
        if (!IGroupable.DEFAULT_XML_GROUP_AS_BEHAVIOR.equals((Object)xmlGroupAsBehavior)) {
            groupAsAnnoation.addMember("inXml", "$T.$L", new Object[]{XmlGroupAsBehavior.class, xmlGroupAsBehavior.toString()});
        }
        return groupAsAnnoation;
    }
}

