/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.typeinfo;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.ClassUtils;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.AbstractModelInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IFlagInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.INamedModelInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.ITypeResolver;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IAssemblyDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IModelDefinitionTypeInfo;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Modifier;

abstract class AbstractNamedModelInstanceTypeInfo<INSTANCE extends INamedModelInstanceAbsolute>
extends AbstractModelInstanceTypeInfo<INSTANCE>
implements INamedModelInstanceTypeInfo {
    public AbstractNamedModelInstanceTypeInfo(@NonNull INSTANCE instance, @NonNull IAssemblyDefinitionTypeInfo parentDefinition) {
        super(instance, parentDefinition);
    }

    @Override
    @NonNull
    public String getBaseName() {
        INamedModelInstanceAbsolute modelInstance = (INamedModelInstanceAbsolute)this.getInstance();
        String retval = modelInstance.getMaxOccurs() == -1 || modelInstance.getMaxOccurs() > 1 ? super.getBaseName() : modelInstance.getEffectiveName();
        return retval;
    }

    @Override
    public String getItemBaseName() {
        return ((INamedModelInstanceAbsolute)this.getInstance()).getEffectiveName();
    }

    @Override
    public TypeName getJavaItemType() {
        return ((IAssemblyDefinitionTypeInfo)this.getParentTypeInfo()).getTypeResolver().getClassName(this);
    }

    @Override
    public Set<IModelDefinition> buildField(TypeSpec.Builder typeBuilder, FieldSpec.Builder fieldBuilder) {
        Set<IModelDefinition> retval = super.buildField(typeBuilder, fieldBuilder);
        IModelDefinition definition = ((INamedModelInstanceAbsolute)this.getInstance()).getDefinition();
        if (definition.isInline() && (definition.hasChildren() || definition instanceof IAssemblyDefinition)) {
            retval = new LinkedHashSet<IModelDefinition>(retval);
            retval.add(definition);
        }
        return retval.isEmpty() ? CollectionUtil.emptySet() : CollectionUtil.unmodifiableSet(retval);
    }

    @Override
    public Set<IModelDefinition> buildBindingAnnotation(TypeSpec.Builder typeBuilder, FieldSpec.Builder fieldBuilder, AnnotationSpec.Builder annotation) {
        int maxOccurs;
        this.buildBindingAnnotationCommon(annotation);
        INamedModelInstanceAbsolute instance = (INamedModelInstanceAbsolute)this.getInstance();
        int minOccurs = instance.getMinOccurs();
        if (minOccurs != 0) {
            annotation.addMember("minOccurs", "$L", new Object[]{minOccurs});
        }
        if ((maxOccurs = instance.getMaxOccurs()) != 1) {
            annotation.addMember("maxOccurs", "$L", new Object[]{maxOccurs});
        }
        if (maxOccurs == -1 || maxOccurs > 1) {
            annotation.addMember("groupAs", "$L", new Object[]{this.generateGroupAsAnnotation().build()});
        }
        return CollectionUtil.emptySet();
    }

    @Override
    protected void buildExtraMethods(TypeSpec.Builder builder, FieldSpec valueField) {
        super.buildExtraMethods(builder, valueField);
        INamedModelInstanceAbsolute instance = (INamedModelInstanceAbsolute)this.getInstance();
        int maxOccurance = instance.getMaxOccurs();
        if (maxOccurance == -1 || maxOccurance > 1) {
            TypeName itemType = this.getJavaItemType();
            ParameterSpec valueParam = ParameterSpec.builder((TypeName)itemType, (String)"item", (Modifier[])new Modifier[0]).build();
            String itemPropertyName = ClassUtils.toPropertyName(this.getItemBaseName());
            if (JsonGroupAsBehavior.KEYED.equals((Object)instance.getJsonGroupAsBehavior())) {
                IFlagInstance jsonKey = instance.getDefinition().getJsonKey();
                if (jsonKey == null) {
                    throw new IllegalStateException(String.format("JSON key not defined for property: %s", instance.toCoordinates()));
                }
                ITypeResolver typeResolver = ((IAssemblyDefinitionTypeInfo)this.getParentTypeInfo()).getTypeResolver();
                IModelDefinitionTypeInfo instanceTypeInfo = typeResolver.getTypeInfo(instance.getDefinition());
                IFlagInstanceTypeInfo jsonKeyTypeInfo = instanceTypeInfo.getFlagInstanceTypeInfo(jsonKey);
                if (jsonKeyTypeInfo == null) {
                    throw new IllegalStateException(String.format("Unable to identify JSON key for property: %s", instance.toCoordinates()));
                }
                MethodSpec.Builder method = MethodSpec.methodBuilder((String)("add" + itemPropertyName)).addParameter(valueParam).returns(itemType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Add a new {@link $T} item to the underlying collection.\n", new Object[]{itemType}).addJavadoc("@param item the item to add\n", new Object[0]).addJavadoc("@return the existing {@link $T} item in the collection or {@code null} if not item exists\n", new Object[]{itemType}).addStatement("$1T value = $2T.requireNonNull($3N,\"$3N value cannot be null\")", new Object[]{itemType, ObjectUtils.class, valueParam}).addStatement("$1T key = $2T.requireNonNull($3N.$4N(),\"$3N key cannot be null\")", new Object[]{String.class, ObjectUtils.class, valueParam, "get" + jsonKeyTypeInfo.getPropertyName()}).beginControlFlow("if ($N == null)", new Object[]{valueField}).addStatement("$N = new $T<>()", new Object[]{valueField, LinkedHashMap.class}).endControlFlow().addStatement("return $N.put(key, value)", new Object[]{valueField});
                builder.addMethod(method.build());
                method = MethodSpec.methodBuilder((String)("remove" + itemPropertyName)).addParameter(valueParam).returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Remove the {@link $T} item from the underlying collection.\n", new Object[]{itemType}).addJavadoc("@param item the item to remove\n", new Object[0]).addJavadoc("@return {@code true} if the item was removed or {@code false} otherwise\n", new Object[0]).addStatement("$1T value = $2T.requireNonNull($3N,\"$3N value cannot be null\")", new Object[]{itemType, ObjectUtils.class, valueParam}).addStatement("$1T key = $2T.requireNonNull($3N.$4N(),\"$3N key cannot be null\")", new Object[]{String.class, ObjectUtils.class, valueParam, "get" + jsonKeyTypeInfo.getPropertyName()}).addStatement("return $1N != null && $1N.remove(key, value)", new Object[]{valueField});
                builder.addMethod(method.build());
            } else {
                MethodSpec.Builder method = MethodSpec.methodBuilder((String)("add" + itemPropertyName)).addParameter(valueParam).returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Add a new {@link $T} item to the underlying collection.\n", new Object[]{itemType}).addJavadoc("@param item the item to add\n", new Object[0]).addJavadoc("@return {@code true}\n", new Object[0]).addStatement("$T value = $T.requireNonNull($N,\"$N cannot be null\")", new Object[]{itemType, ObjectUtils.class, valueParam, valueParam}).beginControlFlow("if ($N == null)", new Object[]{valueField}).addStatement("$N = new $T<>()", new Object[]{valueField, LinkedList.class}).endControlFlow().addStatement("return $N.add(value)", new Object[]{valueField});
                builder.addMethod(method.build());
                method = MethodSpec.methodBuilder((String)("remove" + itemPropertyName)).addParameter(valueParam).returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Remove the first matching {@link $T} item from the underlying collection.\n", new Object[]{itemType}).addJavadoc("@param item the item to remove\n", new Object[0]).addJavadoc("@return {@code true} if the item was removed or {@code false} otherwise\n", new Object[0]).addStatement("$T value = $T.requireNonNull($N,\"$N cannot be null\")", new Object[]{itemType, ObjectUtils.class, valueParam, valueParam}).addStatement("return $1N != null && $1N.remove(value)", new Object[]{valueField});
                builder.addMethod(method.build());
            }
        }
    }
}

