/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.typeinfo;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.AbstractTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IPropertyTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IDefinitionTypeInfo;
import java.util.Set;
import javax.lang.model.element.Modifier;

public abstract class AbstractPropertyTypeInfo<PARENT extends IDefinitionTypeInfo>
extends AbstractTypeInfo<PARENT>
implements IPropertyTypeInfo {
    protected AbstractPropertyTypeInfo(@NonNull PARENT parentDefinition) {
        super(parentDefinition);
    }

    public Set<IModelDefinition> build(@NonNull TypeSpec.Builder builder) {
        TypeName javaFieldType = this.getJavaFieldType();
        FieldSpec.Builder field = FieldSpec.builder((TypeName)javaFieldType, (String)this.getJavaFieldName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        assert (field != null);
        Set<IModelDefinition> retval = this.buildField(builder, field);
        FieldSpec valueField = (FieldSpec)ObjectUtils.notNull((Object)field.build());
        builder.addField(valueField);
        this.buildExtraMethods(builder, valueField);
        return retval;
    }

    protected void buildExtraMethods(@NonNull TypeSpec.Builder typeBuilder, @NonNull FieldSpec fieldBuilder) {
        TypeName javaFieldType = this.getJavaFieldType();
        String propertyName = this.getPropertyName();
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)("get" + propertyName)).returns(javaFieldType).addModifiers(new Modifier[]{Modifier.PUBLIC});
        assert (method != null);
        method.addStatement("return $N", new Object[]{fieldBuilder});
        typeBuilder.addMethod(method.build());
        ParameterSpec valueParam = ParameterSpec.builder((TypeName)javaFieldType, (String)"value", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)("set" + propertyName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(valueParam);
        assert (method2 != null);
        method2.addStatement("$N = $N", new Object[]{fieldBuilder, valueParam});
        typeBuilder.addMethod(method2.build());
    }

    protected Set<IModelDefinition> buildField(@NonNull TypeSpec.Builder typeBuilder, @NonNull FieldSpec.Builder fieldBuilder) {
        this.buildFieldJavadoc(fieldBuilder);
        return CollectionUtil.emptySet();
    }
}

