/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.typeinfo;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedDefinitionClass;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedModuleClass;
import gov.nist.secauto.metaschema.databind.codegen.impl.AnnotationGenerator;
import gov.nist.secauto.metaschema.databind.codegen.impl.DefaultGeneratedClass;
import gov.nist.secauto.metaschema.databind.codegen.impl.DefaultGeneratedDefinitionClass;
import gov.nist.secauto.metaschema.databind.codegen.impl.DefaultGeneratedModuleClass;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IMetaschemaClassFactory;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IPropertyTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.ITypeResolver;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IAssemblyDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IFieldDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IModelDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.model.AbstractBoundModule;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaPackage;
import gov.nist.secauto.metaschema.databind.model.annotations.NsBinding;
import gov.nist.secauto.metaschema.databind.model.annotations.XmlNs;
import gov.nist.secauto.metaschema.databind.model.annotations.XmlNsForm;
import gov.nist.secauto.metaschema.databind.model.annotations.XmlSchema;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DefaultMetaschemaClassFactory
implements IMetaschemaClassFactory {
    @NonNull
    private final ITypeResolver typeResolver;

    @NonNull
    public static DefaultMetaschemaClassFactory newInstance(@NonNull ITypeResolver typeResolver) {
        return new DefaultMetaschemaClassFactory(typeResolver);
    }

    protected DefaultMetaschemaClassFactory(@NonNull ITypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Override
    @NonNull
    public ITypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public IGeneratedModuleClass generateClass(IModule module, Path targetDirectory) throws IOException {
        ClassName className = this.getTypeResolver().getClassName(module);
        TypeSpec.Builder classSpec = this.newClassBuilder(module, className);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classSpec.build()).build();
        Path classFile = (Path)ObjectUtils.notNull((Object)javaFile.writeToPath(targetDirectory));
        Stream globalDefinitions = Stream.concat(module.getAssemblyDefinitions().stream(), module.getFieldDefinitions().stream());
        LinkedHashSet classNames = new LinkedHashSet();
        Map definitionProductions = (Map)ObjectUtils.notNull(globalDefinitions.flatMap(definition -> {
            IModelDefinitionTypeInfo typeInfo = null;
            if (definition instanceof IAssemblyDefinition) {
                typeInfo = IAssemblyDefinitionTypeInfo.newTypeInfo((IAssemblyDefinition)definition, this.typeResolver);
            } else if (definition instanceof IFieldDefinition && !definition.getFlagInstances().isEmpty()) {
                typeInfo = IFieldDefinitionTypeInfo.newTypeInfo((IFieldDefinition)definition, this.typeResolver);
            }
            return typeInfo == null ? null : Stream.of(typeInfo);
        }).map(typeInfo -> {
            IGeneratedDefinitionClass generatedClass;
            IModelDefinition definition = typeInfo.getDefinition();
            try {
                generatedClass = this.generateClass((IModelDefinitionTypeInfo)typeInfo, targetDirectory);
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException(String.format("Unable to generate class for definition '%s' in Module '%s'", definition.getName(), module.getLocation()), ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            String defClassName = generatedClass.getClassName().canonicalName();
            if (classNames.contains(defClassName)) {
                throw new IllegalStateException(String.format("Found duplicate class '%s' in metaschema '%s'. All class names must be unique within the same namespace.", defClassName, module.getLocation()));
            }
            classNames.add(defClassName);
            return generatedClass;
        }).collect(Collectors.toUnmodifiableMap(IGeneratedDefinitionClass::getDefinition, Function.identity())));
        String packageName = this.typeResolver.getPackageName(module);
        return new DefaultGeneratedModuleClass(module, className, classFile, definitionProductions, packageName);
    }

    @Override
    public IGeneratedDefinitionClass generateClass(IModelDefinitionTypeInfo typeInfo, Path targetDirectory) throws IOException {
        ClassName className = typeInfo.getClassName();
        TypeSpec.Builder classSpec = this.newClassBuilder(typeInfo, false);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classSpec.build()).build();
        Path classFile = (Path)ObjectUtils.notNull((Object)javaFile.writeToPath(targetDirectory));
        return new DefaultGeneratedDefinitionClass(classFile, className, typeInfo.getDefinition());
    }

    @Override
    public IGeneratedClass generatePackageInfoClass(String javaPackage, URI xmlNamespace, Collection<IGeneratedModuleClass> moduleProductions, Path targetDirectory) throws IOException {
        String packagePath = javaPackage.replace(".", "/");
        Path packageInfo = (Path)ObjectUtils.notNull((Object)targetDirectory.resolve(packagePath + "/package-info.java"));
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(packageInfo, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));){
            writer.format("@%1$s(moduleClass = {%n", MetaschemaPackage.class.getName());
            boolean first = true;
            for (IGeneratedModuleClass moduleProduction : moduleProductions) {
                if (first) {
                    first = false;
                } else {
                    writer.format(",%n", new Object[0]);
                }
                writer.format("  %1$s.class", moduleProduction.getClassName().canonicalName());
            }
            writer.format("})%n", new Object[0]);
            writer.format("@%1$s(namespace = \"%2$s\", xmlns = {@%3$s(prefix = \"\", namespace = \"%2$s\")}, xmlElementFormDefault = %4$s.QUALIFIED)%n", XmlSchema.class.getName(), xmlNamespace.toString(), XmlNs.class.getName(), XmlNsForm.class.getName());
            writer.format("package %s;%n", javaPackage);
        }
        return new DefaultGeneratedClass(packageInfo, (ClassName)ObjectUtils.notNull((Object)ClassName.get((String)javaPackage, (String)"package-info", (String[])new String[0])));
    }

    @NonNull
    protected TypeSpec.Builder newClassBuilder(@NonNull IModule module, @NonNull ClassName className) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL});
        builder.superclass(AbstractBoundModule.class);
        builder.addAnnotation(this.buildModuleAnnotation(module).build());
        builder.addField(FieldSpec.builder(MarkupLine.class, (String)"NAME", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.fromMarkdown($S)", new Object[]{MarkupLine.class, module.getName().toMarkdown()}).build());
        builder.addField(FieldSpec.builder(String.class, (String)"SHORT_NAME", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{module.getShortName()}).build());
        builder.addField(FieldSpec.builder(String.class, (String)"VERSION", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{module.getVersion()}).build());
        builder.addField(FieldSpec.builder(URI.class, (String)"XML_NAMESPACE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.create($S)", new Object[]{URI.class, module.getXmlNamespace()}).build());
        builder.addField(FieldSpec.builder(URI.class, (String)"JSON_BASE_URI", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.create($S)", new Object[]{URI.class, module.getJsonBaseUri()}).build());
        MarkupMultiline remarks = module.getRemarks();
        if (remarks != null) {
            builder.addField(FieldSpec.builder(MarkupMultiline.class, (String)"REMARKS", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.fromMarkdown($S)", new Object[]{MarkupMultiline.class, remarks.toMarkdown()}).build());
        }
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(IBoundModule.class).box()}), "importedModules", new Modifier[0]).addParameter(IBindingContext.class, "bindingContext", new Modifier[0]).addStatement("super($N, $N)", new Object[]{"importedModules", "bindingContext"}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(MarkupLine.class).addStatement("return NAME", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getShortName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return SHORT_NAME", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getVersion").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return VERSION", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getXmlNamespace").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(URI.class).addStatement("return XML_NAMESPACE", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getJsonBaseUri").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(URI.class).addStatement("return JSON_BASE_URI", new Object[0]).build());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getRemarks").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(MarkupMultiline.class);
        if (remarks == null) {
            methodBuilder.addStatement("return null", new Object[0]);
        } else {
            methodBuilder.addStatement("return REMARKS", new Object[0]);
        }
        builder.addMethod(methodBuilder.build());
        return builder;
    }

    @NonNull
    protected TypeSpec.Builder newClassBuilder(@NonNull IModelDefinitionTypeInfo typeInfo, boolean isChild) throws IOException {
        Set<IModelDefinition> additionalChildClasses;
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)typeInfo.getClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        assert (builder != null);
        if (isChild) {
            builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        builder.addSuperinterface((TypeName)ClassName.get(IBoundObject.class));
        builder.addField(FieldSpec.builder(IMetaschemaData.class, (String)"__metaschemaData", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this(null)", new Object[0]).build());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(IMetaschemaData.class, "data", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"__metaschemaData", "data"}).build());
        MethodSpec.Builder getMetaschemaData = MethodSpec.methodBuilder((String)"getMetaschemaData").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(IMetaschemaData.class).addAnnotation(Override.class).addStatement("return __metaschemaData", new Object[0]);
        builder.addMethod(getMetaschemaData.build());
        ClassName baseClassName = typeInfo.getBaseClassName();
        if (baseClassName != null) {
            builder.superclass((TypeName)baseClassName);
        }
        for (ClassName superinterface : typeInfo.getSuperinterfaces()) {
            builder.addSuperinterface((TypeName)superinterface);
        }
        if (typeInfo instanceof IAssemblyDefinitionTypeInfo) {
            additionalChildClasses = this.buildClass((IAssemblyDefinitionTypeInfo)typeInfo, builder);
        } else if (typeInfo instanceof IFieldDefinitionTypeInfo) {
            additionalChildClasses = this.buildClass((IFieldDefinitionTypeInfo)typeInfo, builder);
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported type: %s", typeInfo.getClass().getName()));
        }
        ITypeResolver typeResolver = this.getTypeResolver();
        for (IModelDefinition definition : additionalChildClasses) {
            assert (definition != null);
            IModelDefinitionTypeInfo childTypeInfo = typeResolver.getTypeInfo(definition);
            TypeSpec childClass = this.newClassBuilder(childTypeInfo, true).build();
            builder.addType(childClass);
        }
        return (TypeSpec.Builder)ObjectUtils.notNull((Object)builder);
    }

    private AnnotationSpec.Builder buildModuleAnnotation(@NonNull IModule module) {
        MarkupMultiline remarks;
        AnnotationSpec.Builder retval = AnnotationSpec.builder(MetaschemaModule.class);
        ITypeResolver typeResolver = this.getTypeResolver();
        for (IFieldDefinition definition : module.getFieldDefinitions()) {
            if (!definition.hasChildren()) continue;
            retval.addMember("fields", "$T.class", new Object[]{typeResolver.getClassName((IModelDefinition)definition)});
        }
        for (IFieldDefinition definition : module.getAssemblyDefinitions()) {
            retval.addMember("assemblies", "$T.class", new Object[]{typeResolver.getClassName((IModelDefinition)ObjectUtils.notNull((Object)definition))});
        }
        for (Object moduleImport : module.getImportedModules()) {
            retval.addMember("imports", "$T.class", new Object[]{typeResolver.getClassName((IModule)ObjectUtils.notNull((Object)moduleImport))});
        }
        Map bindings = module.getNamespaceBindings();
        if (!bindings.isEmpty()) {
            for (Map.Entry entry : bindings.entrySet()) {
                retval.addMember("nsBindings", "$L", new Object[]{AnnotationSpec.builder(NsBinding.class).addMember("prefix", "$S", new Object[]{entry.getKey()}).addMember("uri", "$S", new Object[]{entry.getValue()}).build()});
            }
        }
        if ((remarks = module.getRemarks()) != null) {
            retval.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
        }
        return retval;
    }

    protected Set<IModelDefinition> buildClass(@NonNull IAssemblyDefinitionTypeInfo typeInfo, @NonNull TypeSpec.Builder builder) {
        MarkupMultiline remarks;
        AnnotationSpec.Builder metaschemaAssembly = (AnnotationSpec.Builder)ObjectUtils.notNull((Object)AnnotationSpec.builder(MetaschemaAssembly.class));
        this.buildCommonProperties(typeInfo, metaschemaAssembly);
        IAssemblyDefinition definition = typeInfo.getDefinition();
        if (definition.isRoot()) {
            metaschemaAssembly.addMember("rootName", "$S", new Object[]{definition.getRootName()});
        }
        if ((remarks = definition.getRemarks()) != null) {
            metaschemaAssembly.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
        }
        AnnotationGenerator.buildValueConstraints(metaschemaAssembly, (IModelDefinition)definition);
        AnnotationGenerator.buildAssemblyConstraints(metaschemaAssembly, definition);
        builder.addAnnotation(metaschemaAssembly.build());
        return new LinkedHashSet<IModelDefinition>(this.buildClass((IModelDefinitionTypeInfo)typeInfo, builder));
    }

    protected Set<IModelDefinition> buildClass(@NonNull IFieldDefinitionTypeInfo typeInfo, @NonNull TypeSpec.Builder builder) {
        AnnotationSpec.Builder metaschemaField = (AnnotationSpec.Builder)ObjectUtils.notNull((Object)AnnotationSpec.builder(MetaschemaField.class));
        this.buildCommonProperties(typeInfo, metaschemaField);
        IFieldDefinition definition = typeInfo.getDefinition();
        AnnotationGenerator.buildValueConstraints(metaschemaField, (IModelDefinition)definition);
        builder.addAnnotation(metaschemaField.build());
        return new LinkedHashSet<IModelDefinition>(this.buildClass((IModelDefinitionTypeInfo)typeInfo, builder));
    }

    @NonNull
    protected Set<IModelDefinition> buildClass(@NonNull IModelDefinitionTypeInfo typeInfo, @NonNull TypeSpec.Builder builder) {
        MarkupLine description = typeInfo.getDefinition().getDescription();
        if (description != null) {
            builder.addJavadoc(description.toHtml(), new Object[0]);
        }
        LinkedHashSet<? extends IModelDefinition> additionalChildClasses = new LinkedHashSet<IModelDefinition>();
        for (IPropertyTypeInfo property : typeInfo.getPropertyTypeInfos()) {
            assert (property != null);
            additionalChildClasses.addAll(property.build(builder));
        }
        MethodSpec.Builder toString = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Override.class);
        toString.addStatement("return new $T(this, $T.MULTI_LINE_STYLE).toString()", new Object[]{ReflectionToStringBuilder.class, ToStringStyle.class});
        builder.addMethod(toString.build());
        return CollectionUtil.unmodifiableSet(additionalChildClasses);
    }

    protected void buildCommonProperties(@NonNull IModelDefinitionTypeInfo typeInfo, @NonNull AnnotationSpec.Builder builder) {
        MarkupLine description;
        IModelDefinition definition = typeInfo.getDefinition();
        String formalName = definition.getEffectiveFormalName();
        if (formalName != null) {
            builder.addMember("formalName", "$S", new Object[]{formalName});
        }
        if ((description = definition.getEffectiveDescription()) != null) {
            builder.addMember("description", "$S", new Object[]{description.toMarkdown()});
        }
        builder.addMember("name", "$S", new Object[]{definition.getName()});
        IModule module = definition.getContainingModule();
        builder.addMember("moduleClass", "$T.class", new Object[]{this.getTypeResolver().getClassName(module)});
    }
}

