/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.typeinfo;

import com.squareup.javapoet.ClassName;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.INamedInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.ClassUtils;
import gov.nist.secauto.metaschema.databind.codegen.config.IBindingConfiguration;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.GroupedAssemblyInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.GroupedFieldInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IChoiceGroupTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IGroupedAssemblyInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IGroupedFieldInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IGroupedNamedModelInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.INamedModelInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.ITypeResolver;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IAssemblyDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IFieldDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IModelDefinitionTypeInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DefaultTypeResolver
implements ITypeResolver {
    private static final Logger LOGGER = LogManager.getLogger(DefaultTypeResolver.class);
    private final Map<String, Set<String>> packageToClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private final Lock classNameLock = new ReentrantLock();
    private final Map<IModelDefinition, ClassName> definitionToTypeMap = new ConcurrentHashMap<IModelDefinition, ClassName>();
    private final Map<IModule, ClassName> moduleToTypeMap = new ConcurrentHashMap<IModule, ClassName>();
    private final Map<IAssemblyDefinition, IAssemblyDefinitionTypeInfo> assemblyDefinitionToTypeInfoMap = new ConcurrentHashMap<IAssemblyDefinition, IAssemblyDefinitionTypeInfo>();
    private final Map<IFieldDefinition, IFieldDefinitionTypeInfo> fieldDefinitionToTypeInfoMap = new ConcurrentHashMap<IFieldDefinition, IFieldDefinitionTypeInfo>();
    private final Lock propertyNameLock = new ReentrantLock();
    private final Map<IDefinitionTypeInfo, Set<String>> typeInfoToPropertyNameMap = new ConcurrentHashMap<IDefinitionTypeInfo, Set<String>>();
    @NonNull
    private final IBindingConfiguration bindingConfiguration;

    public DefaultTypeResolver(@NonNull IBindingConfiguration bindingConfiguration) {
        this.bindingConfiguration = bindingConfiguration;
    }

    protected IBindingConfiguration getBindingConfiguration() {
        return this.bindingConfiguration;
    }

    @Override
    public IAssemblyDefinitionTypeInfo getTypeInfo(@NonNull IAssemblyDefinition definition) {
        return (IAssemblyDefinitionTypeInfo)ObjectUtils.notNull((Object)this.assemblyDefinitionToTypeInfoMap.computeIfAbsent(definition, def -> IAssemblyDefinitionTypeInfo.newTypeInfo((IAssemblyDefinition)ObjectUtils.notNull((Object)def), (ITypeResolver)this)));
    }

    @Override
    public IFieldDefinitionTypeInfo getTypeInfo(@NonNull IFieldDefinition definition) {
        return (IFieldDefinitionTypeInfo)ObjectUtils.notNull((Object)this.fieldDefinitionToTypeInfoMap.computeIfAbsent(definition, def -> IFieldDefinitionTypeInfo.newTypeInfo((IFieldDefinition)ObjectUtils.notNull((Object)def), (ITypeResolver)this)));
    }

    @Override
    public IModelDefinitionTypeInfo getTypeInfo(@NonNull IModelDefinition definition) {
        IModelDefinitionTypeInfo retval;
        if (definition instanceof IAssemblyDefinition) {
            retval = this.getTypeInfo((IAssemblyDefinition)definition);
        } else if (definition instanceof IFieldDefinition) {
            retval = this.getTypeInfo((IFieldDefinition)definition);
        } else {
            throw new IllegalStateException(String.format("Unknown type '%s'", definition.getClass().getName()));
        }
        return retval;
    }

    @Override
    public IGroupedNamedModelInstanceTypeInfo getTypeInfo(@NonNull INamedModelInstanceGrouped modelInstance, @NonNull IChoiceGroupTypeInfo choiceGroupTypeInfo) {
        IGroupedNamedModelInstanceTypeInfo retval;
        if (modelInstance instanceof IAssemblyInstanceGrouped) {
            retval = DefaultTypeResolver.getTypeInfo((IAssemblyInstanceGrouped)modelInstance, choiceGroupTypeInfo);
        } else if (modelInstance instanceof IFieldInstanceGrouped) {
            retval = DefaultTypeResolver.getTypeInfo((IFieldInstanceGrouped)modelInstance, choiceGroupTypeInfo);
        } else {
            throw new IllegalStateException(String.format("Unknown type '%s'", modelInstance.getClass().getName()));
        }
        return retval;
    }

    @NonNull
    private static IGroupedAssemblyInstanceTypeInfo getTypeInfo(@NonNull IAssemblyInstanceGrouped modelInstance, @NonNull IChoiceGroupTypeInfo choiceGroupTypeInfo) {
        return new GroupedAssemblyInstanceTypeInfo(modelInstance, choiceGroupTypeInfo);
    }

    @NonNull
    private static IGroupedFieldInstanceTypeInfo getTypeInfo(@NonNull IFieldInstanceGrouped modelInstance, @NonNull IChoiceGroupTypeInfo choiceGroupTypeInfo) {
        return new GroupedFieldInstanceTypeInfo(modelInstance, choiceGroupTypeInfo);
    }

    @NonNull
    private ClassName getFlagContainerClassName(@NonNull IModelDefinition definition, @NonNull String packageName, @NonNull String suggestedClassName) {
        ClassName retval;
        if (definition.isInline()) {
            INamedInstance inlineInstance = definition.getInlineInstance();
            IModelDefinition parentDefinition = inlineInstance.getContainingDefinition();
            ClassName parentClassName = this.getClassName(parentDefinition);
            retval = this.getSubclassName(parentClassName, suggestedClassName, definition);
        } else {
            String className = this.generateClassName(packageName, suggestedClassName, definition);
            retval = (ClassName)ObjectUtils.notNull((Object)ClassName.get((String)packageName, (String)className, (String[])new String[0]));
        }
        return retval;
    }

    @Override
    public ClassName getSubclassName(@NonNull ClassName parentClass, @NonNull String suggestedClassName, @NonNull IModelDefinition definition) {
        String name = this.generateClassName((String)ObjectUtils.notNull((Object)parentClass.canonicalName()), ClassUtils.toClassName(suggestedClassName), definition);
        return (ClassName)ObjectUtils.notNull((Object)parentClass.nestedClass(name));
    }

    @Override
    @NonNull
    public ClassName getClassName(@NonNull IModelDefinition definition) {
        return (ClassName)ObjectUtils.notNull((Object)this.definitionToTypeMap.computeIfAbsent(definition, def -> {
            String packageName = this.getBindingConfiguration().getPackageNameForModule(def.getContainingModule());
            String suggestedClassName = this.getBindingConfiguration().getClassName(definition);
            return this.getFlagContainerClassName((IModelDefinition)def, packageName, suggestedClassName);
        }));
    }

    @Override
    public ClassName getClassName(@NonNull INamedModelInstanceTypeInfo typeInfo) {
        return this.getClassName(typeInfo.getInstance().getDefinition());
    }

    @Override
    public ClassName getClassName(IChoiceGroupInstance instance) {
        return (ClassName)ObjectUtils.notNull((Object)ClassName.get(Object.class));
    }

    @Override
    public ClassName getClassName(IModule module) {
        return (ClassName)ObjectUtils.notNull((Object)this.moduleToTypeMap.computeIfAbsent(module, mod -> {
            assert (mod != null);
            String packageName = this.getBindingConfiguration().getPackageNameForModule((IModule)mod);
            Object className = this.getBindingConfiguration().getClassName((IModule)mod);
            String classNameBase = className;
            int index = 1;
            this.classNameLock.lock();
            try {
                while (this.isClassNameClash(packageName, (String)className)) {
                    className = classNameBase + Integer.toString(index);
                }
                this.addClassName(packageName, (String)className);
            }
            finally {
                this.classNameLock.unlock();
            }
            return ClassName.get((String)packageName, (String)className, (String[])new String[0]);
        }));
    }

    @NonNull
    protected Set<String> getClassNamesFor(@NonNull String packageOrTypeName) {
        this.classNameLock.lock();
        try {
            Set set = (Set)ObjectUtils.notNull((Object)this.packageToClassNamesMap.computeIfAbsent(packageOrTypeName, pkg -> Collections.synchronizedSet(new LinkedHashSet())));
            return set;
        }
        finally {
            this.classNameLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClassNameClash(@NonNull String packageOrTypeName, @NonNull String className) {
        this.classNameLock.lock();
        try {
            boolean bl = this.getClassNamesFor(packageOrTypeName).contains(className);
            return bl;
        }
        finally {
            this.classNameLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addClassName(@NonNull String packageOrTypeName, @NonNull String className) {
        this.classNameLock.lock();
        try {
            boolean bl = this.getClassNamesFor(packageOrTypeName).add(className);
            return bl;
        }
        finally {
            this.classNameLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateClassName(@NonNull String packageOrTypeName, @NonNull String suggestedClassName, @NonNull IModelDefinition definition) {
        Object retval = suggestedClassName;
        boolean clash = false;
        this.classNameLock.lock();
        try {
            Set<String> classNames = this.getClassNamesFor(packageOrTypeName);
            if (classNames.contains(suggestedClassName)) {
                clash = true;
                String metaschemaShortName = definition.getContainingModule().getShortName();
                retval = ClassUtils.toClassName(suggestedClassName + StringUtils.capitalize((String)metaschemaShortName));
            }
            String classNameBase = retval;
            int index = 1;
            while (classNames.contains(retval)) {
                retval = classNameBase + Integer.toString(index++);
            }
            classNames.add((String)retval);
        }
        finally {
            this.classNameLock.unlock();
        }
        if (clash && LOGGER.isWarnEnabled()) {
            LOGGER.warn(String.format("Class name '%s', based on '%s' in '%s', clashes with another bound class. Using '%s' instead.", suggestedClassName, definition.getName(), definition.getContainingModule().getLocation(), retval));
        }
        return retval;
    }

    @Override
    public ClassName getBaseClassName(IModelDefinition definition) {
        String className = this.bindingConfiguration.getQualifiedBaseClassName(definition);
        ClassName retval = null;
        if (className != null) {
            retval = ClassName.bestGuess((String)className);
        }
        return retval;
    }

    @Override
    public List<ClassName> getSuperinterfaces(IModelDefinition definition) {
        List<String> classNames = this.bindingConfiguration.getQualifiedSuperinterfaceClassNames(definition);
        return (List)ObjectUtils.notNull(classNames.stream().map(ClassName::bestGuess).collect(Collectors.toUnmodifiableList()));
    }

    @Override
    public String getPackageName(@NonNull IModule module) {
        return this.bindingConfiguration.getPackageNameForModule(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public String getPropertyName(IDefinitionTypeInfo parent, String name) {
        this.propertyNameLock.lock();
        try {
            Set propertyNames = this.typeInfoToPropertyNameMap.computeIfAbsent(parent, key -> new HashSet());
            String retval = name;
            int index = 0;
            while (propertyNames.contains(retval)) {
                retval = ClassUtils.toPropertyName(name + Integer.toString(++index));
            }
            propertyNames.add(retval);
            String string = retval;
            return string;
        }
        finally {
            this.propertyNameLock.unlock();
        }
    }
}

