/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.typeinfo;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.impl.AnnotationGenerator;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.AbstractInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IFlagInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IDefinitionTypeInfo;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.JsonFieldValueKeyFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.JsonKey;
import java.util.Set;

public class FlagInstanceTypeInfoImpl
extends AbstractInstanceTypeInfo<IFlagInstance, IDefinitionTypeInfo>
implements IFlagInstanceTypeInfo {
    public FlagInstanceTypeInfoImpl(@NonNull IFlagInstance instance, @NonNull IDefinitionTypeInfo parentDefinition) {
        super(instance, parentDefinition);
    }

    @Override
    public String getBaseName() {
        return ((IFlagInstance)this.getInstance()).getEffectiveName();
    }

    @Override
    public TypeName getJavaFieldType() {
        return (TypeName)ObjectUtils.notNull((Object)ClassName.get((Class)((IFlagInstance)this.getInstance()).getDefinition().getJavaTypeAdapter().getJavaClass()));
    }

    @Override
    public Set<IModelDefinition> buildField(TypeSpec.Builder typeBuilder, FieldSpec.Builder fieldBuilder) {
        IFieldDefinition parentField;
        super.buildField(typeBuilder, fieldBuilder);
        IFlagInstance instance = (IFlagInstance)this.getInstance();
        fieldBuilder.addAnnotation(FlagInstanceTypeInfoImpl.buildBoundFlagAnnotation(instance).build());
        IModelDefinition parent = instance.getContainingDefinition();
        IFlagInstance jsonKey = parent.getJsonKey();
        if (instance.equals(jsonKey)) {
            fieldBuilder.addAnnotation(JsonKey.class);
        }
        if (parent instanceof IFieldDefinition && (parentField = (IFieldDefinition)parent).hasJsonValueKeyFlagInstance() && instance.equals(parentField.getJsonValueKeyFlagInstance())) {
            fieldBuilder.addAnnotation(JsonFieldValueKeyFlag.class);
        }
        return CollectionUtil.emptySet();
    }

    private static AnnotationSpec.Builder buildBoundFlagAnnotation(@NonNull IFlagInstance instance) {
        MarkupLine description;
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(BoundFlag.class);
        String formalName = instance.getEffectiveFormalName();
        if (formalName != null) {
            annotation.addMember("formalName", "$S", new Object[]{formalName});
        }
        if ((description = instance.getEffectiveDescription()) != null) {
            annotation.addMember("description", "$S", new Object[]{description.toMarkdown()});
        }
        annotation.addMember("name", "$S", new Object[]{instance.getEffectiveName()});
        Integer index = instance.getEffectiveIndex();
        if (index != null) {
            annotation.addMember("useIndex", "$L", new Object[]{index});
        }
        IFlagDefinition definition = instance.getDefinition();
        IDataTypeAdapter valueDataType = definition.getJavaTypeAdapter();
        Object defaultValue = instance.getEffectiveDefaultValue();
        if (defaultValue != null) {
            annotation.addMember("defaultValue", "$S", new Object[]{valueDataType.asString(defaultValue)});
        }
        if (instance.isRequired()) {
            annotation.addMember("required", "$L", new Object[]{true});
        }
        annotation.addMember("typeAdapter", "$T.class", new Object[]{valueDataType.getClass()});
        MarkupMultiline remarks = instance.getRemarks();
        if (remarks != null) {
            annotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
        }
        AnnotationGenerator.buildValueConstraints(annotation, definition);
        return annotation;
    }
}

