/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.codegen.typeinfo.def;

import com.squareup.javapoet.ClassName;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.FlagInstanceTypeInfoImpl;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IFlagInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IInstanceTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.IPropertyTypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.ITypeInfo;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.ITypeResolver;
import gov.nist.secauto.metaschema.databind.codegen.typeinfo.def.IModelDefinitionTypeInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import nl.talsmasoftware.lazy4j.Lazy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractModelDefinitionTypeInfo<DEF extends IModelDefinition>
implements IModelDefinitionTypeInfo {
    private static final Logger LOGGER = LogManager.getLogger(AbstractModelDefinitionTypeInfo.class);
    @NonNull
    private final DEF definition;
    @NonNull
    private final ITypeResolver typeResolver;
    @NonNull
    private final ClassName className;
    @Nullable
    private final ClassName baseClassName;
    @NonNull
    private final List<ClassName> superinterfaces;
    @NonNull
    private final Lazy<Map<String, IFlagInstanceTypeInfo>> flagTypeInfos;

    public AbstractModelDefinitionTypeInfo(@NonNull DEF definition, @NonNull ITypeResolver typeResolver) {
        this.definition = definition;
        this.typeResolver = typeResolver;
        this.className = typeResolver.getClassName((IModelDefinition)definition);
        this.baseClassName = typeResolver.getBaseClassName((IModelDefinition)definition);
        this.superinterfaces = typeResolver.getSuperinterfaces((IModelDefinition)definition);
        this.flagTypeInfos = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> (Map)this.flags().collect(CustomCollectors.toMap(ITypeInfo::getPropertyName, (Function)CustomCollectors.identity(), (key, v1, v2) -> {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("Unexpected duplicate flag property name '%s'", key));
            }
            return (IFlagInstanceTypeInfo)ObjectUtils.notNull((Object)v2);
        }, LinkedHashMap::new))));
    }

    public DEF getDefinition() {
        return this.definition;
    }

    @Override
    public ITypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public ClassName getClassName() {
        return this.className;
    }

    @Override
    public ClassName getBaseClassName() {
        return this.baseClassName;
    }

    @Override
    public List<ClassName> getSuperinterfaces() {
        return this.superinterfaces;
    }

    private Stream<IFlagInstanceTypeInfo> flags() {
        return this.getDefinition().getFlagInstances().stream().map(instance -> {
            assert (instance != null);
            return new FlagInstanceTypeInfoImpl((IFlagInstance)instance, this);
        });
    }

    @NonNull
    protected abstract Map<String, IPropertyTypeInfo> getPropertyTypeInfoMap();

    @NonNull
    protected abstract Map<IInstance, IInstanceTypeInfo> getInstanceTypeInfoMap();

    @NonNull
    protected Map<String, IFlagInstanceTypeInfo> getFlagInstanceTypeInfoMap() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.flagTypeInfos.get()));
    }

    @Override
    public Collection<IPropertyTypeInfo> getPropertyTypeInfos() {
        return this.getPropertyTypeInfoMap().values();
    }

    @Override
    @Nullable
    public IInstanceTypeInfo getInstanceTypeInfo(@NonNull IInstance instance) {
        return this.getInstanceTypeInfoMap().get(instance);
    }

    @Override
    public Collection<IInstanceTypeInfo> getInstanceTypeInfos() {
        return this.getInstanceTypeInfoMap().values();
    }

    @Override
    public IFlagInstanceTypeInfo getFlagInstanceTypeInfo(@NonNull IFlagInstance instance) {
        return (IFlagInstanceTypeInfo)this.getInstanceTypeInfo((IInstance)instance);
    }

    @Override
    public Collection<IFlagInstanceTypeInfo> getFlagInstanceTypeInfos() {
        return this.getFlagInstanceTypeInfoMap().values();
    }
}

