/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.core.metapath.DynamicContext;
import gov.nist.secauto.metaschema.core.metapath.IDocumentLoader;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDefinitionNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IRootAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.constraint.DefaultConstraintValidator;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintValidationHandler;
import gov.nist.secauto.metaschema.core.model.constraint.LoggingConstraintValidationHandler;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.AbstractSerializationBase;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.IDeserializer;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractDeserializer<CLASS extends IBoundObject>
extends AbstractSerializationBase<DeserializationFeature<?>>
implements IDeserializer<CLASS> {
    private IConstraintValidationHandler constraintValidationHandler;
    private final Lock handlerLock = new ReentrantLock();

    protected AbstractDeserializer(@NonNull IBoundDefinitionModelAssembly definition) {
        super(definition);
    }

    @Override
    @NonNull
    public IConstraintValidationHandler getConstraintValidationHandler() {
        this.handlerLock.lock();
        try {
            if (this.constraintValidationHandler == null) {
                this.constraintValidationHandler = new LoggingConstraintValidationHandler();
            }
            IConstraintValidationHandler iConstraintValidationHandler = (IConstraintValidationHandler)ObjectUtils.notNull((Object)this.constraintValidationHandler);
            return iConstraintValidationHandler;
        }
        finally {
            this.handlerLock.unlock();
        }
    }

    @Override
    public void setConstraintValidationHandler(@NonNull IConstraintValidationHandler constraintValidationHandler) {
        this.handlerLock.lock();
        try {
            this.constraintValidationHandler = constraintValidationHandler;
        }
        finally {
            this.handlerLock.unlock();
        }
    }

    @Override
    public INodeItem deserializeToNodeItem(Reader reader, URI documentUri) throws IOException {
        INodeItem nodeItem;
        try {
            nodeItem = this.deserializeToNodeItemInternal(reader, documentUri);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (this.isValidating()) {
            this.validate(nodeItem);
        }
        return nodeItem;
    }

    @NonNull
    protected abstract INodeItem deserializeToNodeItemInternal(@NonNull Reader var1, @NonNull URI var2) throws IOException;

    @Override
    public final CLASS deserializeToValue(Reader reader, URI documentUri) throws IOException {
        Object retval;
        if (this.isValidating()) {
            INodeItem nodeItem = this.deserializeToNodeItemInternal(reader, documentUri);
            this.validate(nodeItem);
            retval = (IBoundObject)ObjectUtils.asType((Object)ObjectUtils.requireNonNull((Object)nodeItem.getValue()));
        } else {
            retval = this.deserializeToValueInternal(reader, documentUri);
        }
        return retval;
    }

    private void validate(@NonNull INodeItem nodeItem) {
        IRootAssemblyNodeItem definitionNodeItem;
        if (nodeItem instanceof IDocumentNodeItem) {
            definitionNodeItem = ((IDocumentNodeItem)nodeItem).getRootAssemblyNodeItem();
        } else if (nodeItem instanceof IDefinitionNodeItem) {
            definitionNodeItem = (IDefinitionNodeItem)nodeItem;
        } else {
            throw new UnsupportedOperationException(String.format("The node item type '%s' is not supported for validation.", nodeItem.getClass().getName()));
        }
        DynamicContext dynamicContext = new DynamicContext(nodeItem.getStaticContext());
        dynamicContext.setDocumentLoader((IDocumentLoader)this.getBindingContext().newBoundLoader());
        DefaultConstraintValidator validator = new DefaultConstraintValidator(this.getConstraintValidationHandler());
        validator.validate((INodeItem)definitionNodeItem, dynamicContext);
        validator.finalizeValidation(dynamicContext);
    }

    @NonNull
    protected abstract CLASS deserializeToValueInternal(@NonNull Reader var1, @NonNull URI var2) throws IOException;

    @Override
    public IDeserializer<CLASS> enableFeature(DeserializationFeature<?> feature) {
        return this.set(feature, (Object)true);
    }

    @Override
    public IDeserializer<CLASS> disableFeature(DeserializationFeature<?> feature) {
        return this.set(feature, (Object)false);
    }

    @Override
    public IDeserializer<CLASS> applyConfiguration(@NonNull IConfiguration<DeserializationFeature<?>> other) {
        IMutableConfiguration config = this.getConfiguration();
        config.applyConfiguration(other);
        this.configurationChanged(config);
        return this;
    }

    @Override
    public IDeserializer<CLASS> set(DeserializationFeature<?> feature, Object value) {
        IMutableConfiguration config = this.getConfiguration();
        config.set(feature, value);
        this.configurationChanged(config);
        return this;
    }
}

