/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.databind.io.IProblemHandler;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import java.io.IOException;
import java.util.Collection;

public abstract class AbstractProblemHandler
implements IProblemHandler {
    @Override
    public void handleMissingInstances(IBoundDefinitionModelComplex parentDefinition, IBoundObject targetObject, Collection<? extends IBoundProperty<?>> unhandledInstances) throws IOException {
        AbstractProblemHandler.applyDefaults(targetObject, unhandledInstances);
    }

    protected static void applyDefaults(@NonNull Object targetObject, @NonNull Collection<? extends IBoundProperty<?>> unhandledInstances) throws IOException {
        for (IBoundProperty<?> instance : unhandledInstances) {
            Object value = instance.getResolvedDefaultValue();
            if (value == null) continue;
            instance.setValue(targetObject, value);
        }
    }
}

