/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public enum Format {
    XML(".xml", Set.of()),
    JSON(".json", Set.of()),
    YAML(".yaml", Set.of(".yml"));

    private static final List<String> NAMES;
    @NonNull
    private final String defaultExtension;
    @NonNull
    private final Set<String> recognizedExtensions;

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="Exposes names provided by the enum")
    public static List<String> names() {
        return NAMES;
    }

    private Format(String defaultExtension, Set<String> otherExtensions) {
        this.defaultExtension = defaultExtension;
        HashSet<String> recognizedExtensions = new HashSet<String>();
        recognizedExtensions.add(defaultExtension);
        recognizedExtensions.addAll(otherExtensions);
        this.recognizedExtensions = CollectionUtil.unmodifiableSet(recognizedExtensions);
    }

    @NonNull
    public Set<String> getRecognizedExtensions() {
        return this.recognizedExtensions;
    }

    @NonNull
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    static {
        NAMES = Arrays.stream(Format.values()).map(format -> format.name().toLowerCase(Locale.ROOT)).collect(Collectors.toUnmodifiableList());
    }
}

