/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.format.DataFormatDetector;
import com.fasterxml.jackson.core.format.DataFormatMatcher;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.json.JsonFactoryFactory;
import gov.nist.secauto.metaschema.databind.io.yaml.impl.YamlFactoryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class FormatDetector {
    private final DataFormatDetector detector;

    public FormatDetector() {
        this((IConfiguration<DeserializationFeature<?>>)new DefaultConfiguration());
    }

    public FormatDetector(@NonNull IConfiguration<DeserializationFeature<?>> configuration) {
        this(configuration, FormatDetector.newDetectorFactory(configuration));
    }

    protected FormatDetector(@NonNull IConfiguration<DeserializationFeature<?>> configuration, JsonFactory ... detectors) {
        int lookaheadBytes = (Integer)configuration.get(DeserializationFeature.FORMAT_DETECTION_LOOKAHEAD_LIMIT);
        this.detector = new DataFormatDetector(detectors).withMinimalMatch(MatchStrength.INCONCLUSIVE).withOptimalMatch(MatchStrength.SOLID_MATCH).withMaxInputLookahead(lookaheadBytes - 1);
    }

    @NonNull
    private static JsonFactory[] newDetectorFactory(@NonNull IConfiguration<DeserializationFeature<?>> config) {
        JsonFactory[] detectorFactory = new JsonFactory[]{YamlFactoryFactory.newParserFactoryInstance(config), JsonFactoryFactory.instance(), new XmlFactory()};
        return detectorFactory;
    }

    @NonNull
    public Result detect(@NonNull URL resource) throws IOException {
        try (InputStream is = (InputStream)ObjectUtils.notNull((Object)resource.openStream());){
            Result result = this.detect(is);
            return result;
        }
    }

    @NonNull
    public Result detect(@NonNull InputStream inputStream) throws IOException {
        DataFormatMatcher matcher = this.detector.findFormat(inputStream);
        switch (matcher.getMatchStrength()) {
            case FULL_MATCH: 
            case SOLID_MATCH: 
            case WEAK_MATCH: 
            case INCONCLUSIVE: {
                return new Result(matcher);
            }
        }
        throw new IOException("Unable to identify format");
    }

    public static final class Result {
        @NonNull
        private final DataFormatMatcher matcher;

        private Result(@NonNull DataFormatMatcher matcher) {
            this.matcher = matcher;
        }

        @NonNull
        public Format getFormat() {
            Format retval;
            String formatName = this.matcher.getMatchedFormatName();
            if ("YAML".equals(formatName)) {
                retval = Format.YAML;
            } else if ("JSON".equals(formatName)) {
                retval = Format.JSON;
            } else if ("XML".equals(formatName)) {
                retval = Format.XML;
            } else {
                throw new UnsupportedOperationException(String.format("The detected format '%s' is not supported", formatName));
            }
            return retval;
        }

        @NonNull
        public InputStream getDataStream() {
            return (InputStream)ObjectUtils.notNull((Object)this.matcher.getDataStream());
        }

        @NonNull
        public MatchStrength getMatchStrength() {
            return (MatchStrength)ObjectUtils.notNull((Object)this.matcher.getMatchStrength());
        }
    }
}

