/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.core.metapath.IDocumentLoader;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.FormatDetector;
import gov.nist.secauto.metaschema.databind.io.ISerializer;
import gov.nist.secauto.metaschema.databind.io.ModelDetector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.Owning;

public interface IBoundLoader
extends IDocumentLoader,
IMutableConfiguration<DeserializationFeature<?>> {
    default public IBoundLoader enableFeature(DeserializationFeature<?> feature) {
        return this.set(feature, (Object)true);
    }

    default public IBoundLoader disableFeature(DeserializationFeature<?> feature) {
        return this.set(feature, (Object)false);
    }

    public IBoundLoader applyConfiguration(IConfiguration<DeserializationFeature<?>> var1);

    public IBoundLoader set(DeserializationFeature<?> var1, Object var2);

    @NonNull
    default public Format detectFormat(@NonNull File file) throws IOException {
        return this.detectFormat((Path)ObjectUtils.notNull((Object)file.toPath()));
    }

    @NonNull
    default public Format detectFormat(@NonNull Path path) throws IOException {
        return this.detectFormat((URI)ObjectUtils.notNull((Object)path.toUri()));
    }

    @NonNull
    default public Format detectFormat(@NonNull URL url) throws IOException {
        try {
            return this.detectFormat((URI)ObjectUtils.notNull((Object)url.toURI()));
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    @NonNull
    public Format detectFormat(@NonNull URI var1) throws IOException;

    @NonNull
    public FormatDetector.Result detectFormat(@NonNull InputStream var1) throws IOException;

    @NonNull
    @Owning
    public ModelDetector.Result detectModel(@NonNull InputStream var1, @NonNull Format var2) throws IOException;

    @NonNull
    default public <CLASS extends IBoundObject> CLASS load(@NonNull File file) throws IOException {
        return this.load((Path)ObjectUtils.notNull((Object)file.toPath()));
    }

    @NonNull
    default public <CLASS extends IBoundObject> CLASS load(@NonNull Path path) throws IOException {
        return this.load((URI)ObjectUtils.notNull((Object)path.toUri()));
    }

    @NonNull
    default public <CLASS extends IBoundObject> CLASS load(@NonNull URL url) throws IOException, URISyntaxException {
        return this.load((URI)ObjectUtils.notNull((Object)url.toURI()));
    }

    @NonNull
    public <CLASS extends IBoundObject> CLASS load(@NonNull URI var1) throws IOException;

    @NonNull
    public <CLASS extends IBoundObject> CLASS load(@NonNull InputStream var1, @NonNull URI var2) throws IOException;

    @NonNull
    default public <CLASS extends IBoundObject> CLASS load(@NonNull Class<CLASS> clazz, @NonNull File file) throws IOException {
        return this.load(clazz, (Path)ObjectUtils.notNull((Object)file.toPath()));
    }

    @NonNull
    default public <CLASS extends IBoundObject> CLASS load(@NonNull Class<CLASS> clazz, @NonNull Path path) throws IOException {
        return this.load(clazz, (URI)ObjectUtils.notNull((Object)path.toUri()));
    }

    @NonNull
    default public <CLASS extends IBoundObject> CLASS load(@NonNull Class<CLASS> clazz, @NonNull URL url) throws IOException, URISyntaxException {
        return this.load(clazz, (URI)ObjectUtils.notNull((Object)url.toURI()));
    }

    @NonNull
    public <CLASS extends IBoundObject> CLASS load(@NonNull Class<CLASS> var1, @NonNull URI var2) throws IOException;

    @NonNull
    public <CLASS extends IBoundObject> CLASS load(@NonNull Class<CLASS> var1, @NonNull InputStream var2, @NonNull URI var3) throws IOException;

    @NonNull
    public <CLASS extends IBoundObject> CLASS load(@NonNull Class<CLASS> var1, @NonNull Format var2, @NonNull InputStream var3, @NonNull URI var4) throws IOException;

    @NonNull
    default public IDocumentNodeItem loadAsNodeItem(@NonNull Format format, @NonNull Path path) throws IOException {
        return this.loadAsNodeItem(format, (URI)ObjectUtils.notNull((Object)path.toUri()));
    }

    @NonNull
    public IDocumentNodeItem loadAsNodeItem(@NonNull Format var1, @NonNull URI var2) throws IOException;

    @NonNull
    public IDocumentNodeItem loadAsNodeItem(@NonNull Format var1, @NonNull InputStream var2, @NonNull URI var3) throws IOException;

    @NonNull
    public IBindingContext getBindingContext();

    default public <CLASS extends IBoundObject> void convert(@NonNull Path source, @NonNull Path destination, @NonNull Format toFormat, @NonNull Class<CLASS> rootClass) throws FileNotFoundException, IOException {
        CLASS object = this.load(rootClass, source);
        ISerializer<CLASS> serializer = this.getBindingContext().newSerializer(toFormat, rootClass);
        serializer.serialize((IBoundObject)object, destination, new OpenOption[0]);
    }

    default public <CLASS extends IBoundObject> void convert(@NonNull Path source, @NonNull OutputStream os, @NonNull Format toFormat, @NonNull Class<CLASS> rootClass) throws FileNotFoundException, IOException {
        CLASS object = this.load(rootClass, source);
        ISerializer<CLASS> serializer = this.getBindingContext().newSerializer(toFormat, rootClass);
        serializer.serialize((IBoundObject)object, os);
    }

    default public <CLASS extends IBoundObject> void convert(@NonNull URI source, @NonNull Path destination, @NonNull Format toFormat, @NonNull Class<CLASS> rootClass) throws FileNotFoundException, IOException {
        CLASS object = this.load(rootClass, source);
        ISerializer<CLASS> serializer = this.getBindingContext().newSerializer(toFormat, rootClass);
        serializer.serialize((IBoundObject)object, destination, new OpenOption[0]);
    }

    default public <CLASS extends IBoundObject> void convert(@NonNull URI source, @NonNull OutputStream os, @NonNull Format toFormat, @NonNull Class<CLASS> rootClass) throws FileNotFoundException, IOException {
        CLASS object = this.load(rootClass, source);
        ISerializer<CLASS> serializer = this.getBindingContext().newSerializer(toFormat, rootClass);
        serializer.serialize((IBoundObject)object, os);
    }

    default public <CLASS extends IBoundObject> void convert(@NonNull URI source, @NonNull Writer writer, @NonNull Format toFormat, @NonNull Class<CLASS> rootClass) throws FileNotFoundException, IOException {
        CLASS object = this.load(rootClass, source);
        ISerializer<CLASS> serializer = this.getBindingContext().newSerializer(toFormat, rootClass);
        serializer.serialize((IBoundObject)object, writer);
    }
}

