/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.SerializationFeature;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public interface ISerializer<CLASS extends IBoundObject>
extends IMutableConfiguration<SerializationFeature<?>> {
    public ISerializer<CLASS> enableFeature(SerializationFeature<?> var1);

    public ISerializer<CLASS> disableFeature(SerializationFeature<?> var1);

    public ISerializer<CLASS> applyConfiguration(IConfiguration<SerializationFeature<?>> var1);

    public ISerializer<CLASS> set(SerializationFeature<?> var1, Object var2);

    default public void serialize(@NonNull IBoundObject data, @NonNull OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        this.serialize(data, writer);
        writer.flush();
    }

    default public void serialize(@NonNull IBoundObject data, @NonNull Path path, OpenOption ... openOptions) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, openOptions);){
            if (!1.$assertionsDisabled && writer == null) {
                throw new AssertionError();
            }
            this.serialize(data, writer);
        }
    }

    default public void serialize(@NonNull IBoundObject data, @NonNull File file) throws IOException {
        this.serialize(data, (Path)ObjectUtils.notNull((Object)file.toPath()), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public void serialize(@NonNull IBoundObject var1, @NonNull Writer var2) throws IOException;

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

