/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io;

import com.ctc.wstx.stax.WstxInputFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.MergedStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.util.JsonUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.json.JsonFactoryFactory;
import gov.nist.secauto.metaschema.databind.io.yaml.impl.YamlFactoryFactory;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;
import org.eclipse.jdt.annotation.NotOwning;
import org.eclipse.jdt.annotation.Owning;

public class ModelDetector {
    @NonNull
    private final IBindingContext bindingContext;
    @NonNull
    private final IConfiguration<DeserializationFeature<?>> configuration;

    public ModelDetector(@NonNull IBindingContext bindingContext) {
        this(bindingContext, (IConfiguration<DeserializationFeature<?>>)new DefaultConfiguration());
    }

    public ModelDetector(@NonNull IBindingContext bindingContext, @NonNull IConfiguration<DeserializationFeature<?>> configuration) {
        this.bindingContext = bindingContext;
        this.configuration = configuration;
    }

    private int getLookaheadLimit() {
        return (Integer)this.configuration.get(DeserializationFeature.FORMAT_DETECTION_LOOKAHEAD_LIMIT);
    }

    @NonNull
    private IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NonNull
    private IConfiguration<DeserializationFeature<?>> getConfiguration() {
        return this.configuration;
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    @Owning
    public Result detect(@NonNull @NotOwning InputStream inputStream, @NonNull Format format) throws IOException {
        buf = (byte[])ObjectUtils.notNull((Object)inputStream.readNBytes(this.getLookaheadLimit()));
        bis = new ByteArrayInputStream(buf);
        try {
            if (!ModelDetector.$assertionsDisabled && bis == null) {
                throw new AssertionError();
            }
            switch (1.$SwitchMap$gov$nist$secauto$metaschema$databind$io$Format[format.ordinal()]) {
                case 1: {
                    parser = JsonFactoryFactory.instance().createParser((InputStream)bis);
                    try {
                        if (!ModelDetector.$assertionsDisabled && parser == null) {
                            throw new AssertionError();
                        }
                        clazz = this.detectModelJsonClass(parser);
                        break;
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                case 2: {
                    factory = YamlFactoryFactory.newParserFactoryInstance(this.getConfiguration());
                    parser = factory.createParser((InputStream)bis);
                    try {
                        if (!ModelDetector.$assertionsDisabled && parser == null) {
                            throw new AssertionError();
                        }
                        clazz = this.detectModelJsonClass((JsonParser)parser);
                        break;
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                case 3: {
                    clazz = this.detectModelXmlClass(bis);
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The format '%s' dataStream not supported", new Object[]{format}));
                }
            }
        }
        finally {
            bis.close();
        }
        if (clazz == null) {
            throw new IllegalStateException(String.format("Detected format '%s', but unable to detect the bound data type", new Object[]{format.name()}));
        }
        return new Result(clazz, inputStream, buf);
    }

    @NonNull
    private Class<? extends IBoundObject> detectModelXmlClass(@NonNull InputStream is) throws IOException {
        QName startElementQName;
        try {
            XMLInputFactory2 xmlInputFactory = (XMLInputFactory2)XMLInputFactory.newInstance();
            assert (xmlInputFactory instanceof WstxInputFactory);
            xmlInputFactory.configureForXmlConformance();
            xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", (Object)false);
            InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF8"));
            XMLEventReader2 eventReader = (XMLEventReader2)xmlInputFactory.createXMLEventReader((Reader)reader);
            while (eventReader.hasNext() && !eventReader.peek().isStartElement()) {
                eventReader.nextEvent();
            }
            if (!eventReader.peek().isStartElement()) {
                throw new IOException("Unable to detect a start element");
            }
            StartElement start = eventReader.nextEvent().asStartElement();
            startElementQName = (QName)ObjectUtils.notNull((Object)start.getName());
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        Class<? extends IBoundObject> clazz = this.getBindingContext().getBoundClassForRootXmlQName(startElementQName);
        if (clazz == null) {
            throw new IOException("Unrecognized element name: " + startElementQName.toString());
        }
        return clazz;
    }

    @Nullable
    private Class<? extends IBoundObject> detectModelJsonClass(@NonNull JsonParser parser) throws IOException {
        Class<? extends IBoundObject> retval = null;
        JsonUtil.advanceAndAssert((JsonParser)parser, (JsonToken)JsonToken.START_OBJECT);
        while (JsonToken.FIELD_NAME.equals((Object)parser.nextToken())) {
            String name = (String)ObjectUtils.notNull((Object)parser.currentName());
            if (!"$schema".equals(name)) {
                IBindingContext bindingContext = this.getBindingContext();
                retval = bindingContext.getBoundClassForRootJsonName(name);
                if (retval != null) break;
                throw new IOException("Unrecognized JSON field name: " + name);
            }
            parser.nextToken();
        }
        return retval;
    }

    public static final class Result
    implements Closeable {
        @NonNull
        private final Class<? extends IBoundObject> boundClass;
        @Owning
        private InputStream dataStream;

        private Result(@NonNull Class<? extends IBoundObject> clazz, @NonNull InputStream is, @NonNull byte[] buf) {
            this.boundClass = clazz;
            this.dataStream = new MergedStream(null, is, buf, 0, buf.length);
        }

        @NonNull
        public Class<? extends IBoundObject> getBoundClass() {
            return this.boundClass;
        }

        @NonNull
        @Owning
        public InputStream getDataStream() {
            return (InputStream)ObjectUtils.requireNonNull((Object)this.dataStream, (String)"data stream already closed");
        }

        @Override
        public void close() throws IOException {
            this.dataStream.close();
            this.dataStream = null;
        }
    }
}

