/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItemFactory;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.AbstractDeserializer;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.json.JsonFactoryFactory;
import gov.nist.secauto.metaschema.databind.io.json.MetaschemaJsonReader;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import nl.talsmasoftware.lazy4j.Lazy;

public class DefaultJsonDeserializer<CLASS extends IBoundObject>
extends AbstractDeserializer<CLASS> {
    private Lazy<JsonFactory> factory;

    public DefaultJsonDeserializer(@NonNull IBoundDefinitionModelAssembly definition) {
        super(definition);
        this.resetFactory();
    }

    protected final void resetFactory() {
        this.factory = Lazy.lazy(this::newFactoryInstance);
    }

    @Override
    protected void configurationChanged(IMutableConfiguration<DeserializationFeature<?>> config) {
        super.configurationChanged(config);
        this.resetFactory();
    }

    @NonNull
    protected JsonFactory newFactoryInstance() {
        return JsonFactoryFactory.instance();
    }

    @NonNull
    protected JsonFactory getJsonFactory() {
        return (JsonFactory)ObjectUtils.notNull((Object)((JsonFactory)this.factory.get()));
    }

    @NonNull
    protected final JsonParser newJsonParser(@NonNull Reader reader) throws IOException {
        return (JsonParser)ObjectUtils.notNull((Object)this.getJsonFactory().createParser(reader));
    }

    @Override
    protected INodeItem deserializeToNodeItemInternal(@NonNull Reader reader, @NonNull URI documentUri) throws IOException {
        try (JsonParser jsonParser = this.newJsonParser(reader);){
            IAssemblyNodeItem retval;
            IBoundObject value;
            MetaschemaJsonReader parser = new MetaschemaJsonReader(jsonParser);
            IBoundDefinitionModelAssembly definition = this.getDefinition();
            IMutableConfiguration configuration = this.getConfiguration();
            if (definition.isRoot() && configuration.isFeatureEnabled(DeserializationFeature.DESERIALIZE_JSON_ROOT_PROPERTY)) {
                value = (IBoundObject)ObjectUtils.requireNonNull((Object)((IBoundObject)parser.readObjectRoot(definition, (String)ObjectUtils.notNull((Object)definition.getRootJsonName()))));
                retval = INodeItemFactory.instance().newDocumentNodeItem((IAssemblyDefinition)definition, documentUri, (Object)value);
            } else {
                value = (IBoundObject)ObjectUtils.asType(parser.readObject(definition));
                retval = INodeItemFactory.instance().newAssemblyNodeItem((IAssemblyDefinition)definition, documentUri, (Object)value);
            }
            IAssemblyNodeItem iAssemblyNodeItem = retval;
            return iAssemblyNodeItem;
        }
    }

    @Override
    public CLASS deserializeToValueInternal(@NonNull Reader reader, @NonNull URI documentUri) throws IOException {
        try (JsonParser jsonParser = this.newJsonParser(reader);){
            MetaschemaJsonReader parser = new MetaschemaJsonReader(jsonParser);
            IBoundDefinitionModelAssembly definition = this.getDefinition();
            IMutableConfiguration configuration = this.getConfiguration();
            IBoundObject retval = definition.isRoot() && configuration.isFeatureEnabled(DeserializationFeature.DESERIALIZE_JSON_ROOT_PROPERTY) ? (IBoundObject)ObjectUtils.requireNonNull((Object)((IBoundObject)parser.readObjectRoot(definition, (String)ObjectUtils.notNull((Object)definition.getRootJsonName())))) : (IBoundObject)ObjectUtils.asType((Object)ObjectUtils.requireNonNull(parser.readObject(definition)));
            IBoundObject iBoundObject = retval;
            return (CLASS)iBoundObject;
        }
    }
}

