/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.AbstractSerializer;
import gov.nist.secauto.metaschema.databind.io.SerializationFeature;
import gov.nist.secauto.metaschema.databind.io.json.JsonFactoryFactory;
import gov.nist.secauto.metaschema.databind.io.json.MetaschemaJsonWriter;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import java.io.IOException;
import java.io.Writer;
import nl.talsmasoftware.lazy4j.Lazy;

public class DefaultJsonSerializer<CLASS extends IBoundObject>
extends AbstractSerializer<CLASS> {
    private Lazy<JsonFactory> factory;

    public DefaultJsonSerializer(@NonNull IBoundDefinitionModelAssembly definition) {
        super(definition);
        this.resetFactory();
    }

    protected final void resetFactory() {
        this.factory = Lazy.lazy(this::newFactoryInstance);
    }

    @Override
    protected void configurationChanged(IMutableConfiguration<SerializationFeature<?>> config) {
        super.configurationChanged(config);
        this.resetFactory();
    }

    @NonNull
    protected JsonFactory newFactoryInstance() {
        return JsonFactoryFactory.instance();
    }

    @NonNull
    private JsonFactory getJsonFactory() {
        return (JsonFactory)ObjectUtils.notNull((Object)((JsonFactory)this.factory.get()));
    }

    @NonNull
    private JsonGenerator newJsonGenerator(@NonNull Writer writer) throws IOException {
        JsonFactory factory = this.getJsonFactory();
        return (JsonGenerator)ObjectUtils.notNull((Object)factory.createGenerator(writer).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter()));
    }

    @Override
    public void serialize(IBoundObject data, Writer writer) throws IOException {
        try (JsonGenerator generator = this.newJsonGenerator(writer);){
            IBoundDefinitionModelAssembly definition = this.getDefinition();
            boolean serializeRoot = (Boolean)this.get((IConfigurationFeature)SerializationFeature.SERIALIZE_ROOT);
            if (serializeRoot) {
                generator.writeStartObject();
                generator.writeFieldName(definition.getRootJsonName());
            }
            MetaschemaJsonWriter jsonWriter = new MetaschemaJsonWriter(generator);
            jsonWriter.write(definition, data);
            if (serializeRoot) {
                generator.writeEndObject();
            }
        }
    }
}

