/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.util.JsonUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.io.json.DefaultJsonProblemHandler;
import gov.nist.secauto.metaschema.databind.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.databind.io.json.IJsonProblemHandler;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.IBoundInstance;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelFieldScalar;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedField;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedNamed;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import gov.nist.secauto.metaschema.databind.model.info.AbstractModelInstanceReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IFeatureScalarItemValueHandler;
import gov.nist.secauto.metaschema.databind.model.info.IItemReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nl.talsmasoftware.lazy4j.Lazy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jdt.annotation.NotOwning;

public class MetaschemaJsonReader
implements IJsonParsingContext,
IItemReadHandler {
    private static final Logger LOGGER = LogManager.getLogger(MetaschemaJsonReader.class);
    @NonNull
    private final Deque<JsonParser> parserStack = new LinkedList<JsonParser>();
    @NonNull
    private final IJsonProblemHandler problemHandler;
    @NonNull
    private final Lazy<ObjectMapper> objectMapper;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    public MetaschemaJsonReader(@NonNull JsonParser parser) throws IOException {
        this(parser, new DefaultJsonProblemHandler());
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    public MetaschemaJsonReader(@NonNull JsonParser parser, @NonNull IJsonProblemHandler problemHandler) throws IOException {
        this.problemHandler = problemHandler;
        this.objectMapper = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(ObjectMapper::new));
        this.push(parser);
    }

    @Override
    @NotOwning
    public JsonParser getReader() {
        return (JsonParser)ObjectUtils.notNull((Object)this.parserStack.peek());
    }

    public final void push(JsonParser parser) throws IOException {
        assert (!parser.equals(this.parserStack.peek()));
        if (parser.getCurrentToken() == null) {
            parser.nextToken();
        }
        this.parserStack.push(parser);
    }

    @NonNull
    public final JsonParser pop(@NonNull JsonParser parser) {
        JsonParser old = this.parserStack.pop();
        assert (parser.equals(old));
        return (JsonParser)ObjectUtils.notNull((Object)this.parserStack.peek());
    }

    @Override
    public IJsonProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @NonNull
    protected ObjectMapper getObjectMapper() {
        return (ObjectMapper)ObjectUtils.notNull((Object)((ObjectMapper)this.objectMapper.get()));
    }

    @NonNull
    public <T> T readObject(@NonNull IBoundDefinitionModelComplex definition) throws IOException {
        Object value = definition.readItem(null, this);
        if (value == null) {
            throw new IOException(String.format("Failed to read object '%s'%s.", definition.getDefinitionQName(), JsonUtil.generateLocationMessage((JsonParser)this.getReader())));
        }
        return (T)value;
    }

    @NonNull
    public <T> T readObjectRoot(@NonNull IBoundDefinitionModelComplex definition, @NonNull String expectedFieldName) throws IOException {
        JsonToken token;
        JsonParser parser = this.getReader();
        boolean hasStartObject = JsonToken.START_OBJECT.equals((Object)parser.currentToken());
        if (hasStartObject) {
            JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.START_OBJECT);
        }
        T retval = null;
        while (!JsonToken.END_OBJECT.equals((Object)(token = parser.currentToken())) && token != null) {
            if (!JsonToken.FIELD_NAME.equals((Object)token)) {
                throw new IOException(String.format("Expected FIELD_NAME token, found '%s'", token.toString()));
            }
            String propertyName = (String)ObjectUtils.notNull((Object)parser.currentName());
            if (expectedFieldName.equals(propertyName)) {
                JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.FIELD_NAME);
                retval = (T)definition.readItem(null, this);
                break;
            }
            if (this.getProblemHandler().handleUnknownProperty(definition, null, propertyName, this.getReader())) continue;
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Skipping unhandled JSON field '{}'{}.", (Object)propertyName, (Object)JsonUtil.toString((JsonParser)parser));
            }
            JsonUtil.skipNextValue((JsonParser)parser);
        }
        if (hasStartObject) {
            JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.END_OBJECT);
        }
        if (retval == null) {
            throw new IOException(String.format("Failed to find property with name '%s'%s.", expectedFieldName, JsonUtil.generateLocationMessage((JsonParser)parser)));
        }
        return retval;
    }

    @Nullable
    private Object readInstance(@NonNull IBoundProperty<?> instance, @NonNull IBoundObject parent) throws IOException {
        return instance.readItem(parent, this);
    }

    @Nullable
    private <T> Object readModelInstance(@NonNull IBoundInstanceModel<T> instance, @NonNull IBoundObject parent) throws IOException {
        IModelInstanceCollectionInfo<T> collectionInfo = instance.getCollectionInfo();
        return collectionInfo.readItems(new ModelInstanceReadHandler<T>(instance, parent));
    }

    private Object readFieldValue(@NonNull IBoundFieldValue instance, @NonNull IBoundObject parent) throws IOException {
        return instance.readItem(parent, this);
    }

    @Nullable
    private Object readObjectProperty(@NonNull IBoundObject parent, @NonNull IBoundProperty<?> property) throws IOException {
        Object retval = property instanceof IBoundInstanceModel ? this.readModelInstance((IBoundInstanceModel)property, parent) : (property instanceof IBoundInstance ? this.readInstance(property, parent) : this.readFieldValue((IBoundFieldValue)property, parent));
        return retval;
    }

    @Override
    public Object readItemFlag(IBoundObject parentItem, IBoundInstanceFlag instance) throws IOException {
        return this.readScalarItem(instance);
    }

    @Override
    public Object readItemField(IBoundObject parentItem, IBoundInstanceModelFieldScalar instance) throws IOException {
        return this.readScalarItem(instance);
    }

    @Override
    public IBoundObject readItemField(IBoundObject parentItem, IBoundInstanceModelFieldComplex instance) throws IOException {
        return this.readFieldObject(parentItem, instance.getDefinition(), instance.getJsonProperties(), instance.getEffectiveJsonKey(), this.getProblemHandler());
    }

    @Override
    public IBoundObject readItemField(IBoundObject parentItem, IBoundInstanceModelGroupedField instance) throws IOException {
        GroupedInstanceProblemHandler problemHandler = new GroupedInstanceProblemHandler(instance, this.getProblemHandler());
        IBoundDefinitionModelFieldComplex definition = instance.getDefinition();
        IBoundInstanceFlag jsonValueKeyFlag = definition.getJsonValueKeyFlagInstance();
        IJsonProblemHandler actualProblemHandler = jsonValueKeyFlag == null ? problemHandler : new JsomValueKeyProblemHandler(problemHandler, jsonValueKeyFlag);
        return this.readComplexDefinitionObject(parentItem, definition, instance.getEffectiveJsonKey(), new PropertyBodyHandler(instance.getJsonProperties()), actualProblemHandler);
    }

    @Override
    public IBoundObject readItemField(IBoundObject parentItem, IBoundDefinitionModelFieldComplex definition) throws IOException {
        return this.readFieldObject(parentItem, definition, definition.getJsonProperties(), null, this.getProblemHandler());
    }

    @Override
    public Object readItemFieldValue(IBoundObject parentItem, IBoundFieldValue fieldValue) throws IOException {
        return this.checkMissingFieldValue(this.readScalarItem(fieldValue));
    }

    @Nullable
    private Object checkMissingFieldValue(Object value) throws IOException {
        if (value == null && LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().log("Missing property value{}", (Object)JsonUtil.generateLocationMessage((JsonParser)this.getReader()));
        }
        return value;
    }

    @Override
    public IBoundObject readItemAssembly(IBoundObject parentItem, IBoundInstanceModelAssembly instance) throws IOException {
        IBoundInstanceFlag jsonKey = instance.getJsonKey();
        IBoundDefinitionModelAssembly definition = instance.getDefinition();
        return this.readComplexDefinitionObject(parentItem, definition, jsonKey, new PropertyBodyHandler(instance.getJsonProperties()), this.getProblemHandler());
    }

    @Override
    public IBoundObject readItemAssembly(IBoundObject parentItem, IBoundInstanceModelGroupedAssembly instance) throws IOException {
        return this.readComplexDefinitionObject(parentItem, instance.getDefinition(), instance.getEffectiveJsonKey(), new PropertyBodyHandler(instance.getJsonProperties()), new GroupedInstanceProblemHandler(instance, this.getProblemHandler()));
    }

    @Override
    public IBoundObject readItemAssembly(IBoundObject parentItem, IBoundDefinitionModelAssembly definition) throws IOException {
        return this.readComplexDefinitionObject(parentItem, definition, null, new PropertyBodyHandler(definition.getJsonProperties()), this.getProblemHandler());
    }

    @NonNull
    private Object readScalarItem(@NonNull IFeatureScalarItemValueHandler handler) throws IOException {
        return handler.getJavaTypeAdapter().parse(this.getReader());
    }

    @NonNull
    private IBoundObject readFieldObject(@Nullable IBoundObject parentItem, @NonNull IBoundDefinitionModelFieldComplex definition, @NonNull Map<String, IBoundProperty<?>> jsonProperties, @Nullable IBoundInstanceFlag jsonKey, @NonNull IJsonProblemHandler problemHandler) throws IOException {
        IBoundInstanceFlag jsonValueKey = definition.getJsonValueKeyFlagInstance();
        IJsonProblemHandler actualProblemHandler = jsonValueKey == null ? problemHandler : new JsomValueKeyProblemHandler(problemHandler, jsonValueKey);
        IBoundObject retval = jsonProperties.isEmpty() && jsonValueKey == null ? this.readComplexDefinitionObject(parentItem, definition, jsonKey, (def, parent, problem) -> {
            IBoundFieldValue fieldValue = definition.getFieldValue();
            Object item = this.readItemFieldValue(parent, fieldValue);
            if (item != null) {
                fieldValue.setValue((Object)parent, item);
            }
        }, actualProblemHandler) : this.readComplexDefinitionObject(parentItem, definition, jsonKey, new PropertyBodyHandler(jsonProperties), actualProblemHandler);
        return retval;
    }

    @NonNull
    private IBoundObject readComplexDefinitionObject(@Nullable IBoundObject parentItem, @NonNull IBoundDefinitionModelComplex definition, @Nullable IBoundInstanceFlag jsonKey, @NonNull DefinitionBodyHandler<IBoundDefinitionModelComplex> bodyHandler, @NonNull IJsonProblemHandler problemHandler) throws IOException {
        JsonKeyBodyHandler actualBodyHandler = jsonKey == null ? bodyHandler : new JsonKeyBodyHandler(jsonKey, bodyHandler);
        JsonLocation location = this.getReader().currentLocation();
        IBoundObject item = definition.newInstance(JsonLocation.NA.equals((Object)location) ? null : () -> new MetaschemaData((JsonLocation)ObjectUtils.requireNonNull((Object)location)));
        try {
            definition.callBeforeDeserialize(item, parentItem);
            actualBodyHandler.accept(definition, item, problemHandler);
            definition.callAfterDeserialize(item, parentItem);
        }
        catch (BindingException ex) {
            throw new IOException(ex);
        }
        return item;
    }

    @Override
    public IBoundObject readChoiceGroupItem(IBoundObject parentItem, IBoundInstanceModelChoiceGroup instance) throws IOException {
        IBoundObject retval;
        String discriminatorProperty;
        JsonParser parser = this.getReader();
        ObjectNode node = (ObjectNode)parser.readValueAsTree();
        JsonNode discriminatorNode = node.get(discriminatorProperty = instance.getJsonDiscriminatorProperty());
        if (discriminatorNode == null) {
            throw new IllegalArgumentException(String.format("Unable to find discriminator property '%s' for object at '%s'.", discriminatorProperty, JsonUtil.toString((JsonParser)parser)));
        }
        String discriminator = (String)ObjectUtils.requireNonNull((Object)discriminatorNode.asText());
        IBoundInstanceModelGroupedNamed actualInstance = instance.getGroupedModelInstance(discriminator);
        assert (actualInstance != null);
        try (JsonParser newParser = node.traverse(parser.getCodec());){
            this.push(newParser);
            retval = (IBoundObject)actualInstance.readItem(parentItem, this);
            assert (newParser.currentToken() == null);
            this.pop(newParser);
        }
        parser.nextToken();
        return retval;
    }

    private class ModelInstanceReadHandler<ITEM>
    extends AbstractModelInstanceReadHandler<ITEM> {
        protected ModelInstanceReadHandler(@NonNull IBoundInstanceModel<ITEM> instance, IBoundObject parentItem) {
            super(instance, parentItem);
        }

        @Override
        public List<ITEM> readList() throws IOException {
            JsonParser parser = MetaschemaJsonReader.this.getReader();
            LinkedList<ITEM> items = new LinkedList<ITEM>();
            switch (parser.currentToken()) {
                case START_ARRAY: {
                    JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.START_ARRAY);
                    while (!JsonToken.END_ARRAY.equals((Object)parser.currentToken())) {
                        items.add(this.readItem());
                    }
                    JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.END_ARRAY);
                    break;
                }
                case VALUE_NULL: {
                    JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.VALUE_NULL);
                    break;
                }
                default: {
                    items.add(this.readItem());
                }
            }
            return items;
        }

        @Override
        public Map<String, ITEM> readMap() throws IOException {
            JsonParser parser = MetaschemaJsonReader.this.getReader();
            IBoundInstanceModel instance = this.getCollectionInfo().getInstance();
            LinkedHashMap<String, ITEM> items = new LinkedHashMap<String, ITEM>();
            JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.START_OBJECT);
            while (!JsonToken.END_OBJECT.equals((Object)parser.currentToken())) {
                String key;
                JsonUtil.assertCurrent((JsonParser)parser, (JsonToken[])new JsonToken[]{JsonToken.FIELD_NAME});
                ITEM item = this.readItem();
                if (item == null) {
                    throw new IOException(String.format("Null object encountered'%s.", JsonUtil.generateLocationMessage((JsonParser)parser)));
                }
                IBoundInstanceFlag jsonKey = instance.getItemJsonKey(item);
                assert (jsonKey != null);
                Object keyValue = jsonKey.getValue(item);
                if (keyValue == null) {
                    throw new IOException(String.format("Null value for json-key for definition '%s'", jsonKey.getContainingDefinition().toCoordinates()));
                }
                try {
                    key = jsonKey.getJavaTypeAdapter().asString(keyValue);
                }
                catch (IllegalArgumentException ex) {
                    throw new IOException(String.format("Malformed data '%s'%s. %s", keyValue, JsonUtil.generateLocationMessage((JsonParser)parser), ex.getLocalizedMessage()), ex);
                }
                items.put(key, item);
                JsonUtil.assertCurrent((JsonParser)parser, (JsonToken[])new JsonToken[]{JsonToken.FIELD_NAME, JsonToken.END_OBJECT});
            }
            JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.END_OBJECT);
            return items;
        }

        @Override
        public ITEM readItem() throws IOException {
            IBoundInstanceModel instance = this.getCollectionInfo().getInstance();
            return (ITEM)instance.readItem(this.getParentObject(), MetaschemaJsonReader.this);
        }
    }

    private final class GroupedInstanceProblemHandler
    implements IJsonProblemHandler {
        @NonNull
        private final IBoundInstanceModelGroupedNamed instance;
        @NonNull
        private final IJsonProblemHandler delegate;

        private GroupedInstanceProblemHandler(@NonNull IBoundInstanceModelGroupedNamed instance, IJsonProblemHandler delegate) {
            this.instance = instance;
            this.delegate = delegate;
        }

        @Override
        public void handleMissingInstances(IBoundDefinitionModelComplex parentDefinition, IBoundObject targetObject, Collection<? extends IBoundProperty<?>> unhandledInstances) throws IOException {
            this.delegate.handleMissingInstances(parentDefinition, targetObject, unhandledInstances);
        }

        @Override
        public boolean handleUnknownProperty(IBoundDefinitionModelComplex definition, IBoundObject parentItem, String fieldName, JsonParser parser) throws IOException {
            boolean retval;
            if (this.instance.getParentContainer().getJsonDiscriminatorProperty().equals(fieldName)) {
                JsonUtil.skipNextValue((JsonParser)parser);
                retval = true;
            } else {
                retval = this.delegate.handleUnknownProperty(definition, parentItem, fieldName, MetaschemaJsonReader.this.getReader());
            }
            return retval;
        }
    }

    private final class JsomValueKeyProblemHandler
    implements IJsonProblemHandler {
        @NonNull
        private final IJsonProblemHandler delegate;
        @NonNull
        private final IBoundInstanceFlag jsonValueKeyFlag;
        private boolean foundJsonValueKey;

        private JsomValueKeyProblemHandler(@NonNull IJsonProblemHandler delegate, IBoundInstanceFlag jsonValueKeyFlag) {
            this.delegate = delegate;
            this.jsonValueKeyFlag = jsonValueKeyFlag;
        }

        @Override
        public void handleMissingInstances(IBoundDefinitionModelComplex parentDefinition, IBoundObject targetObject, Collection<? extends IBoundProperty<?>> unhandledInstances) throws IOException {
            this.delegate.handleMissingInstances(parentDefinition, targetObject, unhandledInstances);
        }

        @Override
        public boolean handleUnknownProperty(IBoundDefinitionModelComplex definition, IBoundObject parentItem, String fieldName, JsonParser parser) throws IOException {
            boolean retval;
            if (this.foundJsonValueKey) {
                retval = this.delegate.handleUnknownProperty(definition, parentItem, fieldName, parser);
            } else {
                String key = (String)ObjectUtils.notNull((Object)parser.currentName());
                try {
                    Object keyValue = this.jsonValueKeyFlag.getJavaTypeAdapter().parse(key);
                    this.jsonValueKeyFlag.setValue(ObjectUtils.notNull((Object)parentItem), keyValue);
                }
                catch (IllegalArgumentException ex) {
                    throw new IOException(String.format("Malformed data '%s'%s. %s", key, JsonUtil.generateLocationMessage((JsonParser)parser), ex.getLocalizedMessage()), ex);
                }
                JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.FIELD_NAME);
                IBoundFieldValue fieldValue = ((IBoundDefinitionModelFieldComplex)definition).getFieldValue();
                Object value = MetaschemaJsonReader.this.readItemFieldValue((IBoundObject)ObjectUtils.notNull((Object)parentItem), fieldValue);
                if (value != null) {
                    fieldValue.setValue(ObjectUtils.notNull((Object)parentItem), value);
                }
                this.foundJsonValueKey = true;
                retval = true;
            }
            return retval;
        }
    }

    private final class PropertyBodyHandler
    implements DefinitionBodyHandler<IBoundDefinitionModelComplex> {
        @NonNull
        private final Map<String, IBoundProperty<?>> jsonProperties;

        private PropertyBodyHandler(Map<String, IBoundProperty<?>> jsonProperties) {
            this.jsonProperties = jsonProperties;
        }

        @Override
        public void accept(IBoundDefinitionModelComplex definition, IBoundObject parent, IJsonProblemHandler problemHandler) throws IOException {
            JsonParser parser = MetaschemaJsonReader.this.getReader();
            JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.START_OBJECT);
            HashMap remainingInstances = new HashMap(this.jsonProperties);
            while (JsonToken.FIELD_NAME.equals((Object)parser.currentToken())) {
                String propertyName = (String)ObjectUtils.notNull((Object)parser.currentName());
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("reading property {}", (Object)propertyName);
                }
                IBoundProperty property = (IBoundProperty)remainingInstances.get(propertyName);
                boolean handled = false;
                if (property != null) {
                    parser.nextToken();
                    Object value = MetaschemaJsonReader.this.readObjectProperty(parent, property);
                    if (value != null) {
                        property.setValue(parent, value);
                    }
                    remainingInstances.remove(propertyName);
                    handled = true;
                }
                if (!handled && !problemHandler.handleUnknownProperty(definition, parent, propertyName, MetaschemaJsonReader.this.getReader())) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Skipping unhandled JSON field '{}' {}.", (Object)propertyName, (Object)JsonUtil.toString((JsonParser)parser));
                    }
                    JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.FIELD_NAME);
                    JsonUtil.skipNextValue((JsonParser)parser);
                }
                JsonUtil.assertCurrent((JsonParser)parser, (JsonToken[])new JsonToken[]{JsonToken.FIELD_NAME, JsonToken.END_OBJECT});
            }
            problemHandler.handleMissingInstances(definition, parent, (Collection)ObjectUtils.notNull(remainingInstances.values()));
            JsonUtil.assertAndAdvance((JsonParser)parser, (JsonToken)JsonToken.END_OBJECT);
        }
    }

    @FunctionalInterface
    private static interface DefinitionBodyHandler<DEF extends IBoundDefinitionModelComplex> {
        public void accept(@NonNull DEF var1, @NonNull IBoundObject var2, @NonNull IJsonProblemHandler var3) throws IOException;
    }

    private final class JsonKeyBodyHandler
    implements DefinitionBodyHandler<IBoundDefinitionModelComplex> {
        @NonNull
        private final IBoundInstanceFlag jsonKey;
        @NonNull
        private final DefinitionBodyHandler<IBoundDefinitionModelComplex> bodyHandler;

        private JsonKeyBodyHandler(@NonNull IBoundInstanceFlag jsonKey, DefinitionBodyHandler<IBoundDefinitionModelComplex> bodyHandler) {
            this.jsonKey = jsonKey;
            this.bodyHandler = bodyHandler;
        }

        @Override
        public void accept(IBoundDefinitionModelComplex definition, IBoundObject parent, IJsonProblemHandler problemHandler) throws IOException {
            JsonParser parser = MetaschemaJsonReader.this.getReader();
            JsonUtil.assertCurrent((JsonParser)parser, (JsonToken[])new JsonToken[]{JsonToken.FIELD_NAME});
            String key = (String)ObjectUtils.notNull((Object)parser.currentName());
            try {
                Object value = this.jsonKey.getDefinition().getJavaTypeAdapter().parse(key);
                this.jsonKey.setValue(parent, (String)ObjectUtils.notNull((Object)value.toString()));
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(String.format("Malformed data '%s'%s. %s", key, JsonUtil.generateLocationMessage((JsonParser)parser), ex.getLocalizedMessage()), ex);
            }
            parser.nextToken();
            this.bodyHandler.accept(definition, parent, problemHandler);
        }
    }

    private static class MetaschemaData
    implements IMetaschemaData {
        private final int line;
        private final int column;
        private final long charOffset;
        private final long byteOffset;

        public MetaschemaData(@NonNull JsonLocation location) {
            this.line = location.getLineNr();
            this.column = location.getColumnNr();
            this.charOffset = location.getCharOffset();
            this.byteOffset = location.getByteOffset();
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public long getCharOffset() {
            return this.charOffset;
        }

        public long getByteOffset() {
            return this.byteOffset;
        }
    }
}

