/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.json;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IJsonNamed;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModel;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class MetaschemaJsonUtil {
    private MetaschemaJsonUtil() {
    }

    @NonNull
    public static Map<String, ? extends IBoundProperty<?>> getJsonInstanceMap(@NonNull IBoundDefinitionModel<?> targetDefinition, @Nullable IBoundInstanceFlag jsonKey) {
        Stream<Object> instanceStream;
        Collection flags = targetDefinition.getFlagInstances();
        int flagCount = flags.size() - (jsonKey == null ? 0 : 1);
        if (targetDefinition instanceof IBoundDefinitionModelAssembly) {
            instanceStream = ((IBoundDefinitionModelAssembly)targetDefinition).getModelInstances().stream();
        } else if (targetDefinition instanceof IBoundDefinitionModelFieldComplex) {
            IBoundDefinitionModelFieldComplex targetFieldDefinition = (IBoundDefinitionModelFieldComplex)targetDefinition;
            IBoundInstanceFlag jsonValueKeyFlag = targetFieldDefinition.getJsonValueKeyFlagInstance();
            if (jsonValueKeyFlag == null && flagCount > 0) {
                IBoundFieldValue fieldValue = targetFieldDefinition.getFieldValue();
                instanceStream = Stream.of(fieldValue);
            } else {
                instanceStream = Stream.empty();
            }
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported class binding type: %s", targetDefinition.getClass().getName()));
        }
        instanceStream = jsonKey != null ? Stream.concat(flags.stream().filter(flag -> !jsonKey.equals(flag)), instanceStream) : Stream.concat(flags.stream(), instanceStream);
        return CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)instanceStream.collect(Collectors.toMap(IJsonNamed::getJsonName, Function.identity(), (v1, v2) -> v2, LinkedHashMap::new)))));
    }
}

