/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.json;

import com.fasterxml.jackson.core.JsonGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.databind.io.IWritingContext;
import gov.nist.secauto.metaschema.databind.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.IBoundInstance;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelFieldScalar;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedField;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedNamed;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import gov.nist.secauto.metaschema.databind.model.info.AbstractModelInstanceWriteHandler;
import gov.nist.secauto.metaschema.databind.model.info.IFeatureComplexItemValueHandler;
import gov.nist.secauto.metaschema.databind.model.info.IFeatureScalarItemValueHandler;
import gov.nist.secauto.metaschema.databind.model.info.IItemWriteHandler;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import java.io.IOException;
import java.util.List;

public class MetaschemaJsonWriter
implements IJsonWritingContext,
IItemWriteHandler {
    @NonNull
    private final JsonGenerator generator;

    public MetaschemaJsonWriter(@NonNull JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public JsonGenerator getWriter() {
        return this.generator;
    }

    @Override
    public void write(@NonNull IBoundDefinitionModelComplex definition, @NonNull IBoundObject item) throws IOException {
        definition.writeItem(item, this);
    }

    private <T> void writeInstance(@NonNull IBoundProperty<T> instance, @NonNull IBoundObject parentItem) throws IOException {
        Object value = instance.getValue(parentItem);
        if (value != null && !value.equals(instance.getResolvedDefaultValue())) {
            this.generator.writeFieldName(instance.getJsonName());
            instance.writeItem(value, this);
        }
    }

    private <T> void writeModelInstance(@NonNull IBoundInstanceModel<T> instance, @NonNull Object parentItem) throws IOException {
        IModelInstanceCollectionInfo<T> collectionInfo;
        Object value = instance.getValue(parentItem);
        if (value != null && !(collectionInfo = instance.getCollectionInfo()).isEmpty(value)) {
            this.generator.writeFieldName(instance.getJsonName());
            collectionInfo.writeItems(new ModelInstanceWriteHandler<T>(instance), value);
        }
    }

    private void writeFieldValue(@NonNull IBoundFieldValue fieldValue, @NonNull Object parentItem) throws IOException {
        Object item = fieldValue.getValue(parentItem);
        IBoundInstanceFlag jsonValueKey = fieldValue.getParentFieldDefinition().getJsonValueKeyFlagInstance();
        if (item == null) {
            if (jsonValueKey != null) {
                item = fieldValue.getDefaultValue();
            }
        } else if (item.equals(fieldValue.getResolvedDefaultValue())) {
            item = null;
        }
        if (item != null) {
            String valueKeyName;
            if (jsonValueKey != null) {
                Object keyValue = jsonValueKey.getValue(parentItem);
                if (keyValue == null) {
                    throw new IOException(String.format("Null value for json-value-key for definition '%s'", jsonValueKey.getContainingDefinition().toCoordinates()));
                }
                try {
                    valueKeyName = jsonValueKey.getJavaTypeAdapter().asString(keyValue);
                }
                catch (IllegalArgumentException ex) {
                    throw new IOException(String.format("Invalid value '%s' for json-value-key for definition '%s'", keyValue, jsonValueKey.getContainingDefinition().toCoordinates()), ex);
                }
            } else {
                valueKeyName = fieldValue.getParentFieldDefinition().getEffectiveJsonValueKeyName();
            }
            this.generator.writeFieldName(valueKeyName);
            this.writeItemFieldValue(item, fieldValue);
        }
    }

    @Override
    public void writeItemFlag(Object item, IBoundInstanceFlag instance) throws IOException {
        this.writeScalarItem(item, instance);
    }

    @Override
    public void writeItemField(Object item, IBoundInstanceModelFieldScalar instance) throws IOException {
        this.writeScalarItem(item, instance);
    }

    @Override
    public void writeItemField(IBoundObject item, IBoundInstanceModelFieldComplex instance) throws IOException {
        this.writeModelObject(instance, item, this::writeObjectProperties);
    }

    @Override
    public void writeItemField(IBoundObject item, IBoundInstanceModelGroupedField instance) throws IOException {
        this.writeGroupedModelObject(instance, item, (parent, handler) -> {
            this.writeDiscriminatorProperty(handler);
            this.writeObjectProperties(parent, handler);
        });
    }

    @Override
    public void writeItemField(IBoundObject item, IBoundDefinitionModelFieldComplex definition) throws IOException {
        this.writeDefinitionObject(definition, item, this::writeObjectProperties);
    }

    @Override
    public void writeItemFieldValue(Object item, IBoundFieldValue fieldValue) throws IOException {
        fieldValue.getJavaTypeAdapter().writeJsonValue(item, this.generator);
    }

    @Override
    public void writeItemAssembly(IBoundObject item, IBoundInstanceModelAssembly instance) throws IOException {
        this.writeModelObject(instance, item, this::writeObjectProperties);
    }

    @Override
    public void writeItemAssembly(IBoundObject item, IBoundInstanceModelGroupedAssembly instance) throws IOException {
        this.writeGroupedModelObject(instance, item, (parent, handler) -> {
            this.writeDiscriminatorProperty(handler);
            this.writeObjectProperties(parent, handler);
        });
    }

    @Override
    public void writeItemAssembly(IBoundObject item, IBoundDefinitionModelAssembly definition) throws IOException {
        this.writeDefinitionObject(definition, item, this::writeObjectProperties);
    }

    @Override
    public void writeChoiceGroupItem(IBoundObject item, IBoundInstanceModelChoiceGroup instance) throws IOException {
        IBoundInstanceModelGroupedNamed actualInstance = instance.getItemInstance(item);
        assert (actualInstance != null);
        actualInstance.writeItem(item, this);
    }

    private void writeScalarItem(@NonNull Object item, @NonNull IFeatureScalarItemValueHandler handler) throws IOException {
        handler.getJavaTypeAdapter().writeJsonValue(item, this.generator);
    }

    private <T extends IBoundInstanceModelGroupedNamed> void writeDiscriminatorProperty(@NonNull T instance) throws IOException {
        IBoundInstanceModelChoiceGroup choiceGroup = instance.getParentContainer();
        String discriminatorProperty = choiceGroup.getJsonDiscriminatorProperty();
        String discriminatorValue = instance.getEffectiveDisciminatorValue();
        this.generator.writeStringField(discriminatorProperty, discriminatorValue);
    }

    private <T extends IFeatureComplexItemValueHandler> void writeObjectProperties(@NonNull IBoundObject parent, @NonNull T handler) throws IOException {
        for (IBoundProperty<?> property : handler.getJsonProperties().values()) {
            assert (property != null);
            if (property instanceof IBoundInstanceModel) {
                this.writeModelInstance((IBoundInstanceModel)property, parent);
                continue;
            }
            if (property instanceof IBoundInstance) {
                this.writeInstance(property, parent);
                continue;
            }
            this.writeFieldValue((IBoundFieldValue)property, parent);
        }
    }

    private <T extends IFeatureComplexItemValueHandler> void writeDefinitionObject(@NonNull T handler, @NonNull IBoundObject parent, @NonNull IWritingContext.ObjectWriter<T> propertyWriter) throws IOException {
        this.generator.writeStartObject();
        propertyWriter.accept(parent, handler);
        this.generator.writeEndObject();
    }

    private <T extends IFeatureComplexItemValueHandler & IBoundInstanceModel<IBoundObject>> void writeModelObject(@NonNull T handler, @NonNull IBoundObject parent, @NonNull IWritingContext.ObjectWriter<T> propertyWriter) throws IOException {
        this.generator.writeStartObject();
        IBoundInstanceFlag jsonKey = ((IBoundInstanceModel<IBoundObject>)handler).getItemJsonKey(parent);
        if (jsonKey != null) {
            String key;
            Object keyValue = jsonKey.getValue(parent);
            if (keyValue == null) {
                throw new IOException(String.format("Null value for json-key for definition '%s'", jsonKey.getContainingDefinition().toCoordinates()));
            }
            try {
                key = jsonKey.getJavaTypeAdapter().asString(keyValue);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(String.format("Illegal value '%s' for json-key for definition '%s'", keyValue, jsonKey.getContainingDefinition().toCoordinates()), ex);
            }
            this.generator.writeFieldName(key);
            this.generator.writeStartObject();
        }
        propertyWriter.accept(parent, handler);
        if (jsonKey != null) {
            this.generator.writeEndObject();
        }
        this.generator.writeEndObject();
    }

    private <T extends IFeatureComplexItemValueHandler & IBoundInstanceModelGroupedNamed> void writeGroupedModelObject(@NonNull T handler, @NonNull IBoundObject parent, @NonNull IWritingContext.ObjectWriter<T> propertyWriter) throws IOException {
        this.generator.writeStartObject();
        IBoundInstanceModelChoiceGroup choiceGroup = ((IBoundInstanceModelGroupedNamed)handler).getParentContainer();
        IBoundInstanceFlag jsonKey = choiceGroup.getItemJsonKey(parent);
        if (jsonKey != null) {
            String key;
            Object keyValue = jsonKey.getValue(parent);
            if (keyValue == null) {
                throw new IOException(String.format("Null value for json-key for definition '%s'", jsonKey.getContainingDefinition().toCoordinates()));
            }
            try {
                key = jsonKey.getJavaTypeAdapter().asString(keyValue);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(String.format("Invalid value '%s' for json-key for definition '%s'", keyValue, jsonKey.getContainingDefinition().toCoordinates()), ex);
            }
            this.generator.writeFieldName(key);
            this.generator.writeStartObject();
        }
        propertyWriter.accept(parent, handler);
        if (jsonKey != null) {
            this.generator.writeEndObject();
        }
        this.generator.writeEndObject();
    }

    private class ModelInstanceWriteHandler<ITEM>
    extends AbstractModelInstanceWriteHandler<ITEM> {
        public ModelInstanceWriteHandler(IBoundInstanceModel<ITEM> instance) {
            super(instance);
        }

        @Override
        public void writeList(List<ITEM> items) throws IOException {
            IBoundInstanceModel instance = this.getCollectionInfo().getInstance();
            boolean writeArray = false;
            if (JsonGroupAsBehavior.LIST.equals((Object)instance.getJsonGroupAsBehavior()) || JsonGroupAsBehavior.SINGLETON_OR_LIST.equals((Object)instance.getJsonGroupAsBehavior()) && items.size() > 1) {
                writeArray = true;
                MetaschemaJsonWriter.this.generator.writeStartArray();
            }
            super.writeList(items);
            if (writeArray) {
                MetaschemaJsonWriter.this.generator.writeEndArray();
            }
        }

        @Override
        public void writeItem(ITEM item) throws IOException {
            IBoundInstanceModel instance = this.getInstance();
            instance.writeItem(item, MetaschemaJsonWriter.this);
        }
    }
}

