/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItemFactory;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.AutoCloser;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.AbstractDeserializer;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.xml.CommentFilter;
import gov.nist.secauto.metaschema.databind.io.xml.DefaultXmlProblemHandler;
import gov.nist.secauto.metaschema.databind.io.xml.MetaschemaXmlReader;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import nl.talsmasoftware.lazy4j.Lazy;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;

public class DefaultXmlDeserializer<CLASS extends IBoundObject>
extends AbstractDeserializer<CLASS> {
    private Lazy<XMLInputFactory2> factory;
    @NonNull
    private final IBoundDefinitionModelAssembly rootDefinition;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    public DefaultXmlDeserializer(@NonNull IBoundDefinitionModelAssembly definition) {
        super(definition);
        this.rootDefinition = definition;
        if (!definition.isRoot()) {
            throw new UnsupportedOperationException(String.format("The assembly '%s' is not a root assembly.", definition.getBoundClass().getName()));
        }
        this.resetFactory();
    }

    protected final void resetFactory() {
        this.factory = Lazy.lazy(this::newFactoryInstance);
    }

    @Override
    protected void configurationChanged(IMutableConfiguration<DeserializationFeature<?>> config) {
        super.configurationChanged(config);
        this.resetFactory();
    }

    @NonNull
    protected XMLInputFactory2 newFactoryInstance() {
        XMLInputFactory2 retval = (XMLInputFactory2)XMLInputFactory.newInstance();
        assert (retval instanceof WstxInputFactory);
        retval.configureForXmlConformance();
        retval.setProperty("javax.xml.stream.isCoalescing", (Object)false);
        retval.setProperty("org.codehaus.stax2.preserveLocation", (Object)true);
        if (this.isFeatureEnabled((IConfigurationFeature)DeserializationFeature.DESERIALIZE_XML_ALLOW_ENTITY_RESOLUTION)) {
            retval.setProperty("javax.xml.stream.isReplacingEntityReferences", (Object)true);
            retval.setProperty("javax.xml.stream.isSupportingExternalEntities", (Object)true);
            retval.setProperty("javax.xml.stream.supportDTD", (Object)true);
            retval.setProperty("javax.xml.stream.resolver", (publicID, systemID, baseURI, namespace) -> {
                URI base = URI.create(baseURI);
                URI resource = base.resolve(systemID);
                try {
                    return ObjectUtils.notNull((Object)resource.toURL().openStream());
                }
                catch (IOException ex) {
                    throw new XMLStreamException(ex);
                }
            });
        }
        return retval;
    }

    @NonNull
    private XMLInputFactory2 getXMLInputFactory() {
        return (XMLInputFactory2)ObjectUtils.notNull((Object)((XMLInputFactory2)this.factory.get()));
    }

    @NonNull
    private XMLEventReader2 newXMLEventReader2(@NonNull URI documentUri, @NonNull Reader reader) throws XMLStreamException {
        XMLEventReader2 eventReader = (XMLEventReader2)this.getXMLInputFactory().createXMLEventReader(documentUri.toASCIIString(), reader);
        CommentFilter filter = new CommentFilter();
        return (XMLEventReader2)ObjectUtils.notNull((Object)((XMLEventReader2)this.getXMLInputFactory().createFilteredReader((XMLEventReader)eventReader, (EventFilter)filter)));
    }

    protected final IDocumentNodeItem deserializeToNodeItemInternal(Reader reader, URI documentUri) throws IOException {
        CLASS value = this.deserializeToValueInternal(reader, documentUri);
        return INodeItemFactory.instance().newDocumentNodeItem((IAssemblyDefinition)this.rootDefinition, documentUri, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final CLASS deserializeToValueInternal(Reader reader, URI documentUri) throws IOException {
        try (AutoCloser closer = AutoCloser.autoClose((Object)this.newXMLEventReader2(documentUri, reader), XMLEventReader::close);){
            CLASS CLASS = this.parseXmlInternal((XMLEventReader2)closer.getResource());
            return CLASS;
        }
        catch (XMLStreamException ex) {
            throw new IOException("Unable to create a new XMLEventReader2 instance.", ex);
        }
    }

    @NonNull
    private CLASS parseXmlInternal(@NonNull XMLEventReader2 reader) throws IOException {
        MetaschemaXmlReader parser = new MetaschemaXmlReader(reader, new DefaultXmlProblemHandler());
        try {
            return (CLASS)((IBoundObject)parser.read(this.rootDefinition));
        }
        catch (IOException | AssertionError ex) {
            throw new IOException(String.format("An unexpected error occurred during parsing: %s", ((Throwable)ex).getMessage()), (Throwable)ex);
        }
    }
}

