/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.xml;

import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.util.XmlEventUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.AbstractProblemHandler;
import gov.nist.secauto.metaschema.databind.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.databind.io.xml.IXmlProblemHandler;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.events.Attribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultXmlProblemHandler
extends AbstractProblemHandler
implements IXmlProblemHandler {
    private static final Logger LOGGER = LogManager.getLogger(DefaultXmlProblemHandler.class);
    private static final QName XSI_SCHEMA_LOCATION = new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
    private static final Set<QName> IGNORED_QNAMES = new HashSet<QName>();

    @Override
    public boolean handleUnknownAttribute(IBoundDefinitionModelComplex parentDefinition, IBoundObject targetObject, Attribute attribute, IXmlParsingContext parsingContext) {
        QName qname = attribute.getName();
        if (LOGGER.isWarnEnabled() && !IGNORED_QNAMES.contains(qname)) {
            LOGGER.atWarn().log("Skipping unrecognized attribute '{}'{}.", (Object)qname, (Object)XmlEventUtil.generateLocationMessage((Location)((Location)ObjectUtils.notNull((Object)attribute.getLocation()))));
        }
        return true;
    }

    static {
        IGNORED_QNAMES.add(XSI_SCHEMA_LOCATION);
    }
}

