/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.xml;

import com.ctc.wstx.stax.WstxOutputFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.AbstractSerializer;
import gov.nist.secauto.metaschema.databind.io.SerializationFeature;
import gov.nist.secauto.metaschema.databind.io.xml.MetaschemaXmlWriter;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import nl.talsmasoftware.lazy4j.Lazy;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;

public class DefaultXmlSerializer<CLASS extends IBoundObject>
extends AbstractSerializer<CLASS> {
    private Lazy<XMLOutputFactory2> factory;

    public DefaultXmlSerializer(@NonNull IBoundDefinitionModelAssembly definition) {
        super(definition);
        this.resetFactory();
    }

    protected final void resetFactory() {
        this.factory = Lazy.lazy(this::newFactoryInstance);
    }

    @Override
    protected void configurationChanged(IMutableConfiguration<SerializationFeature<?>> config) {
        super.configurationChanged(config);
        this.resetFactory();
    }

    @NonNull
    protected XMLOutputFactory2 newFactoryInstance() {
        XMLOutputFactory2 retval = (XMLOutputFactory2)XMLOutputFactory.newInstance();
        assert (retval instanceof WstxOutputFactory);
        retval.configureForSpeed();
        retval.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", (Object)true);
        retval.setProperty("javax.xml.stream.isRepairingNamespaces", (Object)true);
        return retval;
    }

    @NonNull
    protected final XMLOutputFactory2 getXMLOutputFactory() {
        return (XMLOutputFactory2)ObjectUtils.notNull((Object)((XMLOutputFactory2)this.factory.get()));
    }

    @NonNull
    protected final XMLStreamWriter2 newXMLStreamWriter(@NonNull Writer writer) throws IOException {
        try {
            return (XMLStreamWriter2)ObjectUtils.notNull((Object)((XMLStreamWriter2)this.getXMLOutputFactory().createXMLStreamWriter(writer)));
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void serialize(IBoundObject data, Writer writer) throws IOException {
        XMLStreamWriter2 streamWriter = this.newXMLStreamWriter(writer);
        IOException caughtException = null;
        IBoundDefinitionModelAssembly definition = this.getDefinition();
        MetaschemaXmlWriter xmlGenerator = new MetaschemaXmlWriter(streamWriter);
        boolean serializeRoot = (Boolean)this.get((IConfigurationFeature)SerializationFeature.SERIALIZE_ROOT);
        try {
            if (serializeRoot) {
                streamWriter.writeStartDocument("UTF-8", "1.0");
                xmlGenerator.writeRoot(definition, data);
            } else {
                xmlGenerator.write(definition, data);
            }
            streamWriter.flush();
            if (serializeRoot) {
                streamWriter.writeEndDocument();
            }
        }
        catch (XMLStreamException ex) {
            caughtException = new IOException(ex);
            throw caughtException;
        }
        finally {
            try {
                streamWriter.close();
            }
            catch (XMLStreamException ex) {
                if (caughtException == null) {
                    throw new IOException(ex);
                }
                caughtException.addSuppressed(ex);
                throw caughtException;
            }
        }
    }
}

